/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.IO;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.PacketTypes;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.IDConflictException;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.IO.PacketPipeline;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaReflectionHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import com.google.common.collect.HashBiMap;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public final class ReikaPacketHelper
extends DragonAPICore {
    private static final HashMap<String, PacketPipeline> pipelines = new HashMap();
    private static final HashBiMap<Short, PacketHandler> handlers = HashBiMap.create();
    private static short handlerID = 0;

    public static void registerPacketHandler(DragonAPIMod mod, String channel, PacketHandler handler) {
        SimpleNetworkWrapper wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(channel);
        PacketPipeline p = new PacketPipeline(mod, channel, handler, wrapper);
        p.registerPacket(DataPacket.class);
        handlers.put((Object)handlerID, (Object)handler);
        pipelines.put(channel, p);
        handlerID = (short)(handlerID + 1);
    }

    public static void registerPacketClass(String channel, Class<? extends PacketObj> c) {
        PacketPipeline pipe = pipelines.get(channel);
        if (pipe == null) {
            throw new MisuseException("Cannot register a packet class to a null pipeline!");
        }
        pipe.registerPacket(c);
    }

    private static short getHandlerID(PacketHandler handler) {
        return handlers.containsValue((Object)handler) ? (Short)handlers.inverse().get((Object)handler) : (short)-1;
    }

    private static PacketHandler getHandlerFromID(short id) {
        return (PacketHandler)handlers.get((Object)id);
    }

    public static void sendNIntPacket(String ch, int id, PacketTarget p, List<Integer> data) {
        int npars = 1 + data.size();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(npars * 4);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            outputStream.writeInt(data.size());
            if (data != null) {
                for (int i : data) {
                    outputStream.writeInt(i);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.PREFIXED, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        p.dispatch(pipe, pack);
    }

    public static void sendNIntPacket(String ch, int id, PacketTarget p, int ... data) {
        ReikaPacketHelper.sendNIntPacket(ch, id, p, ReikaJavaLibrary.makeIntListFromArray(data));
    }

    public static void sendRawPacket(String ch, ByteArrayOutputStream bos) {
        DataOutputStream outputStream = new DataOutputStream(bos);
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.RAW, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER && side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendDataPacket(String ch, ByteArrayOutputStream bos) {
        DataOutputStream outputStream = new DataOutputStream(bos);
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER && side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendDataPacket(String ch, int id, EntityPlayerMP ep, int ... data) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < data.length; ++i) {
            li.add(data[i]);
        }
        ReikaPacketHelper.sendDataPacket(ch, id, ep, li);
    }

    public static void sendDataPacket(String ch, int id, EntityPlayerMP ep, List<Integer> data) {
        int npars = data == null ? 4 : data.size() + 4;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(npars * 4);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    outputStream.writeInt(data.get(i));
                }
            }
            outputStream.writeInt(0);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        pipe.sendToPlayer(pack, ep);
    }

    public static void sendDataPacket(String ch, int id, TileEntity te, EntityPlayerMP ep, int ... data) {
        int npars = data == null ? 4 : data.length + 4;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(npars * 4);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    outputStream.writeInt(data[i]);
                }
            }
            outputStream.writeInt(te.field_145851_c);
            outputStream.writeInt(te.field_145848_d);
            outputStream.writeInt(te.field_145849_e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToPlayer(pack, ep);
        } else if (side == Side.CLIENT) {
            // empty if block
        }
    }

    public static void sendDataPacket(String ch, int id, TileEntity te, int radius, List<Integer> data) {
        int npars = data == null ? 4 : data.size() + 4;
        PacketTarget.RadiusTarget pt = new PacketTarget.RadiusTarget(te, radius);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(npars * 4);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    outputStream.writeInt(data.get(i));
                }
            }
            outputStream.writeInt(te.field_145851_c);
            outputStream.writeInt(te.field_145848_d);
            outputStream.writeInt(te.field_145849_e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            ((PacketTarget)pt).dispatch(pipe, pack);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendDataPacket(String ch, int id, PacketTarget pt, List<Integer> data) {
        int npars = data == null ? 4 : data.size() + 4;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(npars * 4);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    outputStream.writeInt(data.get(i));
                }
            }
            outputStream.writeInt(0);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pt.dispatch(pipe, pack);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendDataPacketToEntireServer(String ch, int id, List<Integer> data) {
        int npars = data == null ? 4 : data.size() + 4;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(npars * 4);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    outputStream.writeInt(data.get(i));
                }
            }
            outputStream.writeInt(0);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToAllOnServer(pack);
        } else if (side == Side.CLIENT) {
            // empty if block
        }
    }

    public static void sendDataPacket(String ch, int id, World world, int x, int y, int z, List<Integer> data) {
        int npars = data == null ? 4 : data.size() + 4;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(npars * 4);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    outputStream.writeInt(data.get(i));
                }
            }
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        if (!world.field_72995_K) {
            pipe.sendToDimension((PacketObj)pack, world);
        } else if (world.field_72995_K) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendLongDataPacket(String ch, int id, World world, int x, int y, int z, List<Long> data) {
        int npars = data == null ? 4 : data.size() + 4;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((npars - 4) * 8 + 8);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    outputStream.writeLong(data.get(i));
                }
            }
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToDimension((PacketObj)pack, world);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendUUIDPacket(String ch, int id, World world, int x, int y, int z, UUID data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(28);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            outputStream.writeLong(data.getMostSignificantBits());
            outputStream.writeLong(data.getLeastSignificantBits());
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.DATA, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToDimension((PacketObj)pack, world);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendDataPacketToEntireServer(String ch, int id, int ... data) {
        ReikaPacketHelper.sendDataPacketToEntireServer(ch, id, ReikaJavaLibrary.makeIntListFromArray(data));
    }

    public static void sendDataPacket(String ch, int id, TileEntity te, int data) {
        ReikaPacketHelper.sendDataPacket(ch, id, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, ReikaJavaLibrary.makeListFrom((Object)data));
    }

    public static void sendDataPacketWithRadius(String ch, int id, TileEntity te, int radius, int ... data) {
        ReikaPacketHelper.sendDataPacket(ch, id, te, radius, ReikaJavaLibrary.makeIntListFromArray(data));
    }

    public static void sendDataPacket(String ch, int id, PacketTarget pt, int ... data) {
        ReikaPacketHelper.sendDataPacket(ch, id, pt, ReikaJavaLibrary.makeIntListFromArray(data));
    }

    public static void sendDataPacket(String ch, int id, World world, int x, int y, int z, int data) {
        ReikaPacketHelper.sendDataPacket(ch, id, world, x, y, z, ReikaJavaLibrary.makeListFrom((Object)data));
    }

    public static void sendDataPacket(String ch, int id, World world, int x, int y, int z, int data1, int data2) {
        ReikaPacketHelper.sendDataPacket(ch, id, world, x, y, z, ReikaJavaLibrary.makeListFromArray(new Object[]{data1, data2}));
    }

    public static void sendDataPacket(String ch, int id, World world, int x, int y, int z, int ... data) {
        ReikaPacketHelper.sendDataPacket(ch, id, world, x, y, z, ReikaJavaLibrary.makeIntListFromArray(data));
    }

    public static void sendLongDataPacket(String ch, int id, TileEntity te, long data) {
        ReikaPacketHelper.sendLongDataPacket(ch, id, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, ReikaJavaLibrary.makeListFrom((Object)data));
    }

    public static void sendDataPacket(String ch, int id, TileEntity te, int data1, int data2) {
        ReikaPacketHelper.sendDataPacket(ch, id, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, ReikaJavaLibrary.makeListFromArray(new Object[]{data1, data2}));
    }

    public static void sendDataPacket(String ch, int id, TileEntity te, int data1, int data2, int data3) {
        ReikaPacketHelper.sendDataPacket(ch, id, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, ReikaJavaLibrary.makeListFromArray(new Object[]{data1, data2, data3}));
    }

    public static void sendDataPacket(String ch, int id, TileEntity te, int data1, int data2, int data3, int data4) {
        ReikaPacketHelper.sendDataPacket(ch, id, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, ReikaJavaLibrary.makeListFromArray(new Object[]{data1, data2, data3, data4}));
    }

    public static void sendDataPacket(String ch, int id, TileEntity te, int ... data) {
        ReikaPacketHelper.sendDataPacket(ch, id, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, ReikaJavaLibrary.makeIntListFromArray(data));
    }

    public static void sendDataPacket(String ch, int id, TileEntity te, long data) {
        ReikaPacketHelper.sendLongDataPacket(ch, id, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, ReikaJavaLibrary.makeListFrom((Object)data));
    }

    public static void writeDirectSound(String ch, int id, World world, double x, double y, double z, String name, float vol, float pitch, boolean scale) {
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            outputStream.writeDouble(x);
            outputStream.writeDouble(y);
            outputStream.writeDouble(z);
            ReikaPacketHelper.writeString(name, outputStream);
            outputStream.writeFloat(vol);
            outputStream.writeFloat(pitch);
            outputStream.writeBoolean(scale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Sound Packet for sound '" + name + "' @ " + x + ", " + y + ", " + z + " threw a packet exception!");
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.FULLSOUND, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToAllAround((PacketObj)pack, world, x, y, z, 20.0);
        } else if (side == Side.CLIENT) {
            // empty if block
        }
    }

    public static void sendSoundPacket(String ch, SoundEnum s, World world, double x, double y, double z, float vol, float pitch, boolean atten) {
        ReikaPacketHelper.sendSoundPacket(ch, s, world, x, y, z, vol, pitch, atten, atten ? 20 : Integer.MAX_VALUE);
    }

    public static void sendSoundPacket(String ch, SoundEnum s, World world, double x, double y, double z, float vol, float pitch, boolean atten, int range) {
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(s.ordinal());
            outputStream.writeDouble(x);
            outputStream.writeDouble(y);
            outputStream.writeDouble(z);
            outputStream.writeFloat(vol);
            outputStream.writeFloat(pitch);
            outputStream.writeBoolean(atten);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Sound Packet for " + s + " threw a packet exception!");
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.SOUND, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToAllAround((PacketObj)pack, world, x, y, z, (double)Math.min(range, atten ? 20 : Integer.MAX_VALUE));
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendStringPacket(String ch, int id, String sg, PacketTarget pt) {
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            ReikaPacketHelper.writeString(sg, outputStream);
            outputStream.writeInt(id);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("String Packet for " + sg + " threw a packet exception!");
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.STRING, pipe);
        pack.setData(dat);
        pt.dispatch(pipe, pack);
    }

    public static void sendStringPacket(String ch, int id, String sg, TileEntity te) {
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            ReikaPacketHelper.writeString(sg, outputStream);
            outputStream.writeInt(id);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("String Packet for " + sg + " threw a packet exception!");
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.STRING, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToDimension((PacketObj)pack, te.field_145850_b);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendStringPacket(String ch, int id, String sg, World world, int x, int y, int z) {
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            ReikaPacketHelper.writeString(sg, outputStream);
            outputStream.writeInt(id);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("String Packet for " + sg + " threw a packet exception!");
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.STRING, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToDimension((PacketObj)pack, world);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendStringIntPacket(String ch, int id, EntityPlayerMP ep, String sg, int ... data) {
        int length = data.length * 4;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            ReikaPacketHelper.writeString(sg, outputStream);
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    outputStream.writeInt(data[i]);
                }
            }
            outputStream.writeInt(0);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.STRINGINT, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToPlayer(pack, ep);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendStringIntPacket(String ch, int id, PacketTarget p, String sg, int ... data) {
        int length = data.length * 4;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            ReikaPacketHelper.writeString(sg, outputStream);
            outputStream.writeInt(id);
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    outputStream.writeInt(data[i]);
                }
            }
            outputStream.writeInt(0);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.STRINGINT, pipe);
        pack.setData(dat);
        p.dispatch(pipe, pack);
    }

    public static void sendStringPacket(String ch, int id, String sg) {
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            ReikaPacketHelper.writeString(sg, outputStream);
            outputStream.writeInt(id);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
            outputStream.writeInt(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.STRING, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToAllOnServer(pack);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendStringPacketWithRadius(String ch, int id, TileEntity te, int radius, String sg) {
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            ReikaPacketHelper.writeString(sg, outputStream);
            outputStream.writeInt(id);
            outputStream.writeInt(te.field_145851_c);
            outputStream.writeInt(te.field_145848_d);
            outputStream.writeInt(te.field_145849_e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.STRING, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToAllAround((PacketObj)pack, te, (double)radius);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendUpdatePacket(String ch, int id, TileEntity te, PacketTarget pt) {
        ReikaPacketHelper.sendUpdatePacket(ch, id, te.field_145851_c, te.field_145848_d, te.field_145849_e, pt);
    }

    public static void sendUpdatePacket(String ch, int id, int x, int y, int z, PacketTarget pt) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(20);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Packet " + ch + "/" + id + " @ " + x + "," + y + "," + z + " threw an update packet exception!");
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.UPDATE, pipe);
        pack.setData(dat);
        pt.dispatch(pipe, pack);
    }

    public static void sendFloatPacket(String ch, int id, TileEntity te, float data) {
        ReikaPacketHelper.sendFloatPacket(ch, id, te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, data);
    }

    public static void sendFloatPacket(String ch, int id, World world, int x, int y, int z, float data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(20);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            outputStream.writeFloat(data);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.FLOAT, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToDimension((PacketObj)pack, world);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendPositionPacket(String ch, int id, Entity e, int data, PacketTarget pt) {
        ReikaPacketHelper.sendPositionPacket(ch, id, e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, data, pt);
    }

    public static void sendPositionPacket(String ch, int id, World world, double x, double y, double z, int data, PacketTarget pt) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(20);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
            outputStream.writeDouble(x);
            outputStream.writeDouble(y);
            outputStream.writeDouble(z);
            outputStream.writeInt(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.POS, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pt.dispatch(pipe, pack);
        } else if (side == Side.CLIENT) {
            pipe.sendToServer(pack);
        }
    }

    public static void sendSyncPacket(String ch, TileEntity te, String field) {
        ReikaPacketHelper.sendSyncPacket(ch, te, field, false);
    }

    public static void sendSyncPacket(String ch, TileEntity te, String field, boolean forceClient) {
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            Field f = ReikaReflectionHelper.getProtectedInheritedField(te, field);
            f.setAccessible(true);
            Object obj = f.get(te);
            ReikaPacketHelper.writeString(field, outputStream);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
            PacketableData type = PacketableData.getType(obj);
            outputStream.writeInt(type.ordinal());
            type.write(outputStream, obj);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.SYNC, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            new PacketTarget.RadiusTarget(te, 24).dispatch(pipe, pack);
        } else if (side == Side.CLIENT) {
            if (forceClient) {
                new PacketTarget.ServerTarget().dispatch(pipe, pack);
            } else {
                DragonAPICore.logError(te + " sent a sync packet from the client! This is not allowed!");
            }
        }
    }

    public static void sendTankSyncPacket(String ch, TileEntity te, String tankField) {
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        int length = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            Field f = ReikaReflectionHelper.getProtectedInheritedField(te, tankField);
            f.setAccessible(true);
            HybridTank tank = (HybridTank)((Object)f.get(te));
            ReikaPacketHelper.writeString(tankField, outputStream);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
            outputStream.writeInt(tank.getLevel());
        }
        catch (ClassCastException ex) {
            DragonAPICore.logError(te + " tried to sync its tank, but it is not a HybridTank instance!");
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        byte[] dat = bos.toByteArray();
        DataPacket pack = new DataPacket();
        pack.init(PacketTypes.TANK, pipe);
        pack.setData(dat);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            new PacketTarget.RadiusTarget(te, 24).dispatch(pipe, pack);
        } else if (side == Side.CLIENT) {
            DragonAPICore.logError(te + " sent a sync packet from the client! This is not allowed!");
        }
    }

    public static void sendNBTPacket(String ch, int id, NBTTagCompound nbt, PacketTarget pt) {
        DataPacket pack = ReikaPacketHelper.getNBTPacket(id, nbt);
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        pack.init(PacketTypes.NBT, pipe);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        pt.dispatch(pipe, pack);
    }

    public static void sendEntitySyncPacket(String ch, Entity e, double range) {
        NBTTagCompound nbt = new NBTTagCompound();
        e.func_70109_d(nbt);
        nbt.func_74768_a("dispatchID", e.func_145782_y());
        DataPacket pack = ReikaPacketHelper.getNBTPacket(APIPacketHandler.PacketIDs.ENTITYSYNC.ordinal(), nbt);
        PacketPipeline pipe = pipelines.get(ch);
        if (pipe == null) {
            DragonAPICore.logError("Attempted to send a packet from an unbound channel!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        pack.init(PacketTypes.NBT, pipe);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            pipe.sendToAllAround((PacketObj)pack, e, range);
        } else if (side == Side.CLIENT) {
            // empty if block
        }
    }

    private static DataPacket getNBTPacket(int id, NBTTagCompound nbt) {
        DataPacket pack = new DataPacket();
        pack.setData(id, nbt);
        return pack;
    }

    public static void updateTileEntityData(World world, int x, int y, int z, String name, DataInputStream in) {
        if (world.func_72904_c(x, y, z, x, y, z)) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te == null) {
                DragonAPICore.logError("Null TileEntity for syncing field " + name);
                return;
            }
            try {
                Field f = ReikaReflectionHelper.getProtectedInheritedField(te, name);
                if (f == null) {
                    return;
                }
                Object data = PacketableData.list[in.readInt()].read(in);
                f.setAccessible(true);
                f.set(te, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateTileEntityTankData(World world, int x, int y, int z, String name, int level) {
        if (world.func_72904_c(x, y, z, x, y, z)) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te == null) {
                DragonAPICore.logError("Null TileEntity for syncing tank field " + name);
                return;
            }
            try {
                Field f = ReikaReflectionHelper.getProtectedInheritedField(te, name);
                if (f == null) {
                    return;
                }
                f.setAccessible(true);
                HybridTank tank = (HybridTank)((Object)f.get(te));
                if (level <= 0) {
                    tank.empty();
                } else if (level > tank.getCapacity()) {
                    level = tank.getCapacity();
                }
                if (!tank.isEmpty()) {
                    Fluid fluid = tank.getActualFluid();
                    tank.setContents(level, fluid);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void writeString(String par0Str, DataOutput par1DataOutput) throws IOException {
        if (par0Str.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        par1DataOutput.writeShort(par0Str.length());
        par1DataOutput.writeChars(par0Str);
    }

    private static String readString(DataInput par0DataInput) throws IOException {
        int short1 = par0DataInput.readShort();
        if (short1 > Short.MAX_VALUE) {
            throw new IOException("Received string length longer than maximum allowed!");
        }
        if (short1 < 0) {
            throw new IOException("Received string length is less than zero!");
        }
        StringBuilder stringbuilder = new StringBuilder();
        for (int j = 0; j < short1; ++j) {
            stringbuilder.append(par0DataInput.readChar());
        }
        return stringbuilder.toString();
    }

    public static void writeString(ByteBuf data, String s) {
        data.writeInt(s.length());
        for (int i = 0; i < s.length(); ++i) {
            data.writeChar((int)s.charAt(i));
        }
    }

    public static String readString(ByteBuf data) {
        int n = data.readInt();
        char[] dat = new char[n];
        for (int i = 0; i < n; ++i) {
            dat[i] = data.readChar();
        }
        return new String(dat);
    }

    public static Packet getPacket(String channel, PacketObj p) {
        PacketPipeline pipe = pipelines.get(channel);
        return pipe != null ? pipe.getMinecraftPacket(p) : null;
    }

    public static void registerVanillaPacketType(DragonAPIMod mod, int id, Class<? extends Packet> c, Side s, EnumConnectionState state) {
        switch (s) {
            case CLIENT: {
                if (state.func_150753_a().containsKey((Object)id)) {
                    throw new IDConflictException(mod, "Packet " + c + " ID " + id + " is already occupied by " + state.func_150753_a().get((Object)id) + "!");
                }
                state.func_150753_a().put((Object)id, c);
                break;
            }
            case SERVER: {
                if (state.func_150755_b().containsKey((Object)id)) {
                    throw new IDConflictException(mod, "Packet " + c + " ID " + id + " is already occupied by " + state.func_150755_b().get((Object)id) + "!");
                }
                state.func_150755_b().put((Object)id, c);
            }
        }
        EnumConnectionState.field_150761_f.put(c, state);
        mod.getModLogger().log("Registering vanilla-type packet " + c + " with ID " + id + " on side " + s);
    }

    public static void syncTileEntity(TileEntity tile) {
        NBTTagCompound NBT = new NBTTagCompound();
        tile.func_145841_b(NBT);
        List li = tile.field_145850_b.func_72872_a(EntityPlayerMP.class, ReikaAABBHelper.getBlockAABB(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e).func_72314_b(4.0, 4.0, 4.0));
        for (EntityPlayerMP ep : li) {
            ReikaPacketHelper.sendNBTPacket("DragonAPIData", APIPacketHandler.PacketIDs.VTILESYNC.ordinal(), NBT, new PacketTarget.PlayerTarget(ep));
        }
    }

    public static abstract class PacketObj
    implements IMessage {
        protected PacketHandler handler;
        protected PacketTypes type;
        protected int byteIndex = 0;

        protected PacketObj() {
        }

        public final void fromBytes(ByteBuf buf) {
            this.readData(buf);
        }

        public final void toBytes(ByteBuf buf) {
            this.writeData(buf);
        }

        public void init(PacketTypes p, PacketPipeline l) {
            this.type = p;
            this.handler = l.getHandler();
        }

        public void readData(ByteBuf data) {
            short id = this.readShort(data);
            this.handler = ReikaPacketHelper.getHandlerFromID(id);
            byte type = this.readByte(data);
            this.type = PacketTypes.getPacketType(type);
        }

        protected int readInt(ByteBuf data) {
            this.byteIndex += 4;
            return data.readInt();
        }

        protected short readShort(ByteBuf data) {
            this.byteIndex += 2;
            return data.readShort();
        }

        protected byte readByte(ByteBuf data) {
            ++this.byteIndex;
            return data.readByte();
        }

        public void writeData(ByteBuf data) {
            data.writeShort((int)ReikaPacketHelper.getHandlerID(this.handler));
            data.writeByte(this.type.ordinal());
        }

        @SideOnly(value=Side.CLIENT)
        public final void handleClient(NetHandlerPlayClient nh) {
            try {
                this.handler.handleData(this, (World)Minecraft.func_71410_x().field_71441_e, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.close();
        }

        public final void handleServer(NetHandlerPlayServer nh) {
            try {
                this.handler.handleData(this, nh.field_147369_b.field_70170_p, (EntityPlayer)nh.field_147369_b);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.close();
        }

        public String toString() {
            String hd = this.handler.getClass().getCanonicalName() + " (ID " + this.handlerID() + ")";
            return "type " + (Object)((Object)this.getType()) + "; Data: " + this.getDataAsString() + " from " + hd;
        }

        protected abstract String getDataAsString();

        private void close() {
            try {
                this.getDataIn().close();
            }
            catch (IOException e) {
                DragonAPIInit.instance.getModLogger().logError("Error closing packet " + this + ". Memory may leak.");
                e.printStackTrace();
            }
        }

        public abstract DataInputStream getDataIn();

        public final String readString() {
            try {
                return ReikaPacketHelper.readString(this.getDataIn());
            }
            catch (IOException e) {
                e.printStackTrace();
                return "ERROR";
            }
        }

        protected final byte[] writeNBTTagCompoundToBytes(NBTTagCompound tag) throws IOException {
            ByteArrayDataOutput buf = ByteStreams.newDataOutput();
            if (tag == null) {
                buf.writeInt(-1);
            } else {
                byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
                buf.writeInt(abyte.length);
                buf.write(abyte);
            }
            return buf.toByteArray();
        }

        protected final NBTTagCompound readNBTTagCompoundFromBuffer(byte[] bytes) throws IOException {
            ByteArrayDataInput buf = ByteStreams.newDataInput((byte[])bytes);
            int short1 = buf.readInt();
            if (short1 < 0) {
                return null;
            }
            byte[] abyte = new byte[short1];
            buf.readFully(abyte);
            return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }

        public final PacketTypes getType() {
            return this.type;
        }

        protected final int handlerID() {
            return ((Short)handlers.inverse().get((Object)this.handler)).shortValue();
        }
    }

    public static class DataPacket
    extends PacketObj {
        protected byte[] bytes;
        private DataInputStream in;

        private void setData(byte[] data) {
            this.bytes = new byte[data.length];
            System.arraycopy(data, 0, this.bytes, 0, this.bytes.length);
        }

        private void setData(int id, NBTTagCompound tag) {
            try {
                byte[] most = this.writeNBTTagCompoundToBytes(tag);
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeInt(id);
                out.write(most);
                this.bytes = out.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void readData(ByteBuf data) {
            super.readData(data);
            byte[] dat = data.array();
            this.bytes = new byte[dat.length - this.byteIndex - 1];
            System.arraycopy(dat, this.byteIndex + 1, this.bytes, 0, this.bytes.length);
        }

        @Override
        public void writeData(ByteBuf data) {
            super.writeData(data);
            data.writeBytes(this.bytes);
        }

        public NBTTagCompound asNBT() {
            try {
                byte[] abyte = new byte[this.bytes.length - 4];
                System.arraycopy(this.bytes, 4, abyte, 0, abyte.length);
                return this.readNBTTagCompoundFromBuffer(abyte);
            }
            catch (IOException e) {
                return null;
            }
        }

        public int getSize() {
            return this.bytes.length;
        }

        public boolean isEmpty() {
            return this.getSize() == 0;
        }

        @Override
        public DataInputStream getDataIn() {
            if (this.in == null) {
                this.in = new DataInputStream(new ByteArrayInputStream(this.bytes));
            }
            return this.in;
        }

        @Override
        protected String getDataAsString() {
            return Arrays.toString(this.bytes);
        }
    }

    private static enum PacketableData {
        INT("I", Integer.class),
        BOOLEAN("B", Boolean.class),
        DOUBLE("D", Double.class),
        FLOAT("F", Float.class),
        STRING("S", String.class);

        private final String id;
        private final Class type;
        private static final HashMap<String, PacketableData> typeMap;
        private static final HashMap<Class, PacketableData> classMap;
        private static final PacketableData[] list;

        private PacketableData(String s, Class c) {
            this.id = s;
            this.type = c;
        }

        private void write(DataOutputStream out, Object obj) throws IOException {
            switch (this) {
                case BOOLEAN: {
                    out.writeBoolean((Boolean)obj);
                    break;
                }
                case DOUBLE: {
                    out.writeDouble((Double)obj);
                    break;
                }
                case FLOAT: {
                    out.writeFloat(((Float)obj).floatValue());
                    break;
                }
                case INT: {
                    out.writeInt((Integer)obj);
                    break;
                }
                case STRING: {
                    ReikaPacketHelper.writeString((String)obj, out);
                }
            }
        }

        private Object read(DataInputStream in) throws IOException {
            switch (this) {
                case BOOLEAN: {
                    return in.readBoolean();
                }
                case DOUBLE: {
                    return in.readDouble();
                }
                case FLOAT: {
                    return Float.valueOf(in.readFloat());
                }
                case INT: {
                    return in.readInt();
                }
                case STRING: {
                    return ReikaPacketHelper.readString(in);
                }
            }
            return null;
        }

        private static PacketableData getType(Object o) {
            return classMap.get(o.getClass());
        }

        private static PacketableData getType(String id) {
            return typeMap.get(id);
        }

        static {
            typeMap = new HashMap();
            classMap = new HashMap();
            list = PacketableData.values();
            for (int i = 0; i < list.length; ++i) {
                typeMap.put(PacketableData.list[i].id, list[i]);
                classMap.put(PacketableData.list[i].type, list[i]);
            }
        }
    }
}

