/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.IO;

import Reika.DragonAPI.Auxiliary.BlockModelRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ReikaLiquidRenderer {
    private static Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();
    public static final int LEVELS = 100;
    private static final BlockModelRenderer.ModelBlockInterface liquidBlock = new BlockModelRenderer.ModelBlockInterface();

    public static IIcon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        return ReikaLiquidRenderer.getFluidTexture(fluidStack.getFluid(), flowing);
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        IIcon icon;
        if (fluid == null) {
            return null;
        }
        IIcon iIcon = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static void setFluidColor(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
    }

    public static void bindFluidTexture(Fluid fluid) {
        if (fluid.equals(FluidRegistry.WATER) || fluid.equals(FluidRegistry.LAVA) || fluid.canBePlacedInWorld()) {
            ReikaTextureHelper.bindTerrainTexture();
        } else {
            ReikaTextureHelper.bindTerrainTexture();
        }
    }

    public static int[] getGLLists(FluidStack fluidStack, World world, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        if (fluid.getBlock() != null) {
            ReikaLiquidRenderer.liquidBlock.baseBlock = fluid.getBlock();
            ReikaLiquidRenderer.liquidBlock.texture = ReikaLiquidRenderer.getFluidTexture(fluidStack, flowing);
        } else {
            ReikaLiquidRenderer.liquidBlock.baseBlock = Blocks.field_150355_j;
            ReikaLiquidRenderer.liquidBlock.texture = ReikaLiquidRenderer.getFluidTexture(fluidStack, flowing);
        }
        cache.put(fluid, diplayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            ReikaLiquidRenderer.liquidBlock.minX = 0.01f;
            ReikaLiquidRenderer.liquidBlock.minY = 0.0;
            ReikaLiquidRenderer.liquidBlock.minZ = 0.01f;
            ReikaLiquidRenderer.liquidBlock.maxX = 0.99f;
            ReikaLiquidRenderer.liquidBlock.maxY = (float)s / 100.0f;
            ReikaLiquidRenderer.liquidBlock.maxZ = 0.99f;
            BlockModelRenderer.renderBlock(liquidBlock, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return diplayLists;
    }
}

