/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChunkSplicedGenerationCache {
    private final HashMap<ChunkCoordIntPair, HashMap<Coordinate, BlockPlace>> data = new HashMap();

    public void setBlock(int x, int y, int z, Block b) {
        this.place(x, y, z, new SetBlock(b));
    }

    public void setBlock(int x, int y, int z, Block b, int meta) {
        this.place(x, y, z, new SetBlock(b, meta));
    }

    public void setBlock(int x, int y, int z, BlockKey bk) {
        this.setBlock(x, y, z, bk.blockID, bk.metadata >= 0 ? bk.metadata : 0);
    }

    public void setTileEntity(int x, int y, int z, Block b, int meta, TileCallback call) {
        this.place(x, y, z, new TileSet(call, b, meta));
    }

    public void setAir(int x, int y, int z) {
        this.setBlock(x, y, z, Blocks.field_150350_a);
    }

    public void place(int x, int y, int z, BlockPlace sb) {
        ChunkCoordIntPair key = ChunkSplicedGenerationCache.getKey(x, z);
        HashMap<Coordinate, BlockPlace> map = this.data.get(key);
        if (map == null) {
            map = new HashMap();
            this.data.put(key, map);
        }
        x = ChunkSplicedGenerationCache.modAndAlign(x);
        z = ChunkSplicedGenerationCache.modAndAlign(z);
        map.put(new Coordinate(x, y, z), sb);
    }

    public static int modAndAlign(int c) {
        if ((c %= 16) < 0 && (c += 16) % 16 == 0) {
            c += 16;
        }
        return c;
    }

    public BlockKey getBlock(int x, int y, int z) {
        ChunkCoordIntPair key = ChunkSplicedGenerationCache.getKey(x, z);
        HashMap<Coordinate, BlockPlace> map = this.data.get(key);
        if (map == null) {
            return null;
        }
        x = ChunkSplicedGenerationCache.modAndAlign(x);
        BlockPlace p = map.get(new Coordinate(x, y, z = ChunkSplicedGenerationCache.modAndAlign(z)));
        return p != null ? p.asBlockKey() : null;
    }

    public boolean hasBlock(int x, int y, int z) {
        ChunkCoordIntPair key = ChunkSplicedGenerationCache.getKey(x, z);
        HashMap<Coordinate, BlockPlace> map = this.data.get(key);
        if (map == null) {
            return false;
        }
        x = ChunkSplicedGenerationCache.modAndAlign(x);
        z = ChunkSplicedGenerationCache.modAndAlign(z);
        return map.containsKey(new Coordinate(x, y, z));
    }

    public HashSet<Coordinate> getLocationsOf(BlockKey key) {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        for (ChunkCoordIntPair p : this.data.keySet()) {
            HashMap<Coordinate, BlockPlace> map = this.data.get(p);
            for (Coordinate c : map.keySet()) {
                BlockPlace bp = map.get(c);
                if (!bp.asBlockKey().equals(key)) continue;
                set.add(c.offset(p.field_77276_a * 16, 0, p.field_77275_b * 16));
            }
        }
        return set;
    }

    public void generate(World world, int chunkX, int chunkZ) {
        this.generate(world, new ChunkCoordIntPair(chunkX, chunkZ));
    }

    public void generate(World world, ChunkCoordIntPair cp) {
        this.doGenerate(world, cp);
        this.data.remove(cp);
    }

    public void generateAll(World world) {
        for (ChunkCoordIntPair cp : this.data.keySet()) {
            this.doGenerate(world, cp);
        }
        this.data.clear();
    }

    private void doGenerate(World world, ChunkCoordIntPair cp) {
        HashMap<Coordinate, BlockPlace> map = this.data.get(cp);
        if (map != null) {
            for (Coordinate c : map.keySet()) {
                BlockPlace bp = map.get(c);
                int x = (cp.field_77276_a << 4) + c.xCoord;
                int y = c.yCoord;
                int z = (cp.field_77275_b << 4) + c.zCoord;
                bp.place(world, x, y, z);
            }
        }
    }

    public void clear() {
        this.data.clear();
    }

    public void duplicate(ChunkSplicedGenerationCache c) {
        this.clear();
        this.data.putAll(c.data);
    }

    public void addDataFromColumnData(int chunkX, int chunkZ, Block[] data) {
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int x = chunkX * 16 + dx;
                int z = chunkZ * 16 + dz;
                int d = dx * 16 + dz;
                int posIndex = d * data.length / 256;
                for (int y = 0; y < 256; ++y) {
                    Block b = data[y + posIndex];
                    this.setBlock(x, y, z, b);
                }
            }
        }
    }

    public String toString() {
        return this.data.toString();
    }

    private static ChunkCoordIntPair getKey(int x, int z) {
        return new ChunkCoordIntPair(x >> 4, z >> 4);
    }

    public static final class RelayCache
    extends ChunkSplicedGenerationCache {
        private final World world;

        public RelayCache(World world) {
            this.world = world;
        }

        @Override
        public void place(int x, int y, int z, BlockPlace sb) {
            sb.place(this.world, x, y, z);
        }
    }

    public static interface TileCallback {
        public void onTilePlaced(World var1, int var2, int var3, int var4, TileEntity var5);
    }

    static class TileSet
    extends SetBlock {
        private final TileCallback callback;

        TileSet(TileCallback c, Block b, int m) {
            super(b, m);
            this.callback = c;
        }

        @Override
        public void place(World world, int x, int y, int z) {
            super.place(world, x, y, z);
            this.callback.onTilePlaced(world, x, y, z, world.func_147438_o(x, y, z));
        }
    }

    static class SetBlock
    implements BlockPlace {
        private final Block block;
        private final int metadata;

        SetBlock(Block b) {
            this(b, 0);
        }

        SetBlock(Block b, int m) {
            this.block = b;
            this.metadata = m;
        }

        @Override
        public void place(World world, int x, int y, int z) {
            world.func_147465_d(x, y, z, this.block, this.metadata, 3);
            if (this.block.getLightValue((IBlockAccess)world, x, y, z) > 0) {
                world.func_147471_g(x, y, z);
                world.func_147479_m(x, y, z);
            }
        }

        @Override
        public final BlockKey asBlockKey() {
            return new BlockKey(this.block, this.metadata);
        }

        public final String toString() {
            return "SET " + this.asBlockKey().toString();
        }
    }

    public static interface BlockPlace {
        public void place(World var1, int var2, int var3, int var4);

        public BlockKey asBlockKey();
    }
}

