/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Interfaces.CustomCropHandler;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public final class SimpleCropHandler
implements CustomCropHandler {
    public final Block crop;
    public final int ripeMeta;
    public final int harvestMeta;
    private final ItemStack seedItem;
    private final ModEntry mod;
    private final int color;
    private final String name;

    public SimpleCropHandler(ModEntry mod, int color, String name, Block b, int ripe, ItemStack seed) {
        this(mod, color, name, b, 0, ripe, seed);
    }

    public SimpleCropHandler(ModEntry mod, int color, String name, Block b, int harvest, int ripe, ItemStack seed) {
        this.crop = b;
        this.ripeMeta = ripe;
        this.harvestMeta = harvest;
        this.seedItem = seed;
        this.mod = mod;
        this.color = color;
        this.name = name;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return this.harvestMeta;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return id == this.crop;
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.isCrop(world.func_147439_a(x, y, z), meta) && meta == this.ripeMeta;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, this.ripeMeta, 3);
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return ReikaItemHelper.matchStacks(is, this.seedItem);
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public void editTileDataForHarvest(World world, int x, int y, int z) {
    }

    @Override
    public boolean initializedProperly() {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return null;
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public ModEntry getMod() {
        return this.mod;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public String getEnumEntryName() {
        return this.name;
    }

    @Override
    public boolean isTileEntity() {
        return false;
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return false;
    }
}

