/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class StructureRenderer {
    private static final RenderItem itemRender = new RenderItem();
    private double rx;
    private double ry;
    private double rz;
    private int secY;
    protected final FilledBlockArray array;
    protected final RenderAccess access;
    protected final RenderBlocks renderer;
    private final HashMap<Coordinate, ItemStack> overrides = new HashMap();
    private final ItemHashMap<ItemStack> itemOverrides = new ItemHashMap();
    private final HashMap<Block, BlockChoiceHook> choiceHooks = new HashMap();
    private final ItemHashMap<BlockRenderHook> renderHooks = new ItemHashMap();
    private final HashMap<Coordinate, EntityRender> entities = new HashMap();
    private static RenderAccess staticRenderAccess = null;
    private static boolean tileRendering = false;
    private static boolean tileRenderingReal = false;
    private static double renderRotationX = 0.0;
    private static double renderRotationY = 0.0;
    private static double renderRotationZ = 0.0;

    public static boolean isRenderingTiles() {
        return tileRendering;
    }

    public static boolean isRenderingRealTiles() {
        return tileRenderingReal;
    }

    public static double getRenderRX() {
        return renderRotationX;
    }

    public static double getRenderRY() {
        return renderRotationY;
    }

    public static double getRenderRZ() {
        return renderRotationZ;
    }

    public StructureRenderer(FilledBlockArray structure) {
        this.array = structure;
        this.access = new RenderAccess(this.array);
        this.renderer = new RenderBlocks((IBlockAccess)this.access);
        this.reset();
    }

    public void resetRotation() {
        this.rx = -30.0;
        this.ry = 45.0;
        this.rz = 0.0;
    }

    public void rotate(double x, double y, double z) {
        this.rx += x;
        this.ry += y;
        this.rz += z;
        renderRotationX = this.rx;
        renderRotationY = this.ry;
        renderRotationZ = this.rz;
    }

    public void reset() {
        this.resetRotation();
        this.resetStepY();
    }

    public void resetStepY() {
        this.secY = 0;
    }

    public void incrementStepY() {
        if (this.secY < this.array.getSizeY() - 1) {
            ++this.secY;
        }
    }

    public void decrementStepY() {
        if (this.secY > 0) {
            --this.secY;
        }
    }

    public void addOverride(int x, int y, int z, ItemStack is) {
        this.overrides.put(new Coordinate(x, y, z), is);
    }

    public void addOverride(ItemStack is, ItemStack render) {
        this.itemOverrides.put(is, render);
    }

    public void addBlockHook(Block b, BlockChoiceHook brh) {
        this.choiceHooks.put(b, brh);
    }

    public void addRenderHook(ItemStack is, BlockRenderHook brh) {
        this.renderHooks.put(is, brh);
    }

    public void addEntityRender(int x, int y, int z, EntityRender e) {
        this.entities.put(new Coordinate(x - this.array.getMidX(), y - this.array.getMidY(), z - this.array.getMidZ()), e);
    }

    private ItemStack getRenderStack(Coordinate pos) {
        BlockChoiceHook bc;
        Block b;
        ItemStack is = this.array.getDisplayAt(pos.xCoord, pos.yCoord, pos.zCoord);
        ItemStack over = this.overrides.get(pos);
        if (over != null) {
            is = over;
        }
        if (is != null && is.func_77973_b() != null && (over = this.itemOverrides.get(is)) != null) {
            is = over;
        }
        if (is != null && is.func_77973_b() != null && (b = Block.func_149634_a((Item)is.func_77973_b())) != null && (bc = this.choiceHooks.get(b)) != null) {
            is = bc.getBlock(pos, is.func_77960_j());
        }
        return is;
    }

    private BlockKey getRenderBlock(Coordinate pos, BlockKey is) {
        BlockChoiceHook bc;
        ItemStack over = this.overrides.get(pos);
        if (over != null) {
            is = new BlockKey(over);
        }
        if (is != null && is.blockID != null && (bc = this.choiceHooks.get(is.blockID)) != null) {
            is = new BlockKey(bc.getBlock(pos, is.metadata));
        }
        return is;
    }

    public void drawSlice(int j, int k) {
        int y = this.array.getMinY() + this.secY;
        int max = Math.max(this.array.getSizeX(), this.array.getSizeZ());
        int dd = max > 16 ? Math.max(12, 28 - max) : 14;
        int ox = 120;
        int oy = 105;
        for (int x = this.array.getMinX(); x <= this.array.getMaxX(); ++x) {
            for (int z = this.array.getMinZ(); z <= this.array.getMaxZ(); ++z) {
                ItemStack is = this.getRenderStack(new Coordinate(x, y, z));
                if (is == null || is.func_77973_b() == null) continue;
                int dx = (x - this.array.getMidX()) * dd;
                int dz = (z - this.array.getMidZ()) * dd;
                ReikaGuiAPI.instance.drawItemStack(itemRender, is, j + dx + ox, k + dz + oy);
            }
        }
    }

    public void draw3D(int j, int k, float ptick, boolean transl) {
        PositionData p;
        int x;
        if (this.array.isEmpty()) {
            return;
        }
        double max = Math.max((double)(this.array.getSizeY() * 1), Math.sqrt(Math.pow(this.array.getSizeX(), 2.0) + Math.pow(this.array.getMaxZ(), 2.0)));
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        if (transl) {
            int sc = ReikaRenderHelper.getGUIScale();
            GuiScreen scr = Minecraft.func_71410_x().field_71462_r;
            GL11.glTranslated((double)((double)(j * 0) + (double)scr.field_146294_l / 2.0 + (double)(16 / sc)), (double)((double)(k * 0) + (double)scr.field_146295_m / 2.0 + (double)(16 / sc)), (double)256.0);
            double s = 12.0;
            double d = 2.0;
            if (max >= 18.0) {
                d = 0.675;
            } else if (max >= 14.0) {
                d = 0.8;
            } else if (max >= 12.0) {
                d = 0.95;
            } else if (max >= 10.0) {
                d = 1.2;
            } else if (max >= 8.0) {
                d = 1.5;
            } else if (max >= 4.0) {
                d = 1.75;
            }
            double dr = -5.75 * d;
            GL11.glTranslated((double)dr, (double)dr, (double)dr);
            GL11.glRotated((double)this.rx, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)this.ry, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)this.rz, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-dr), (double)(-dr), (double)(-dr));
            GL11.glScaled((double)(-d * s), (double)(-d * s), (double)(-d * s));
        }
        tileRendering = true;
        tileRenderingReal = !transl;
        staticRenderAccess = this.access;
        ReikaTextureHelper.bindTerrainTexture();
        Tessellator.field_78398_a.func_78382_b();
        for (x = this.array.getMinX(); x <= this.array.getMaxX(); ++x) {
            for (int y = this.array.getMinY(); y <= this.array.getMaxY(); ++y) {
                for (int z = this.array.getMinZ(); z <= this.array.getMaxZ(); ++z) {
                    p = this.access.getData(x, y, z);
                    if (((PositionData)p).block.blockID == Blocks.field_150350_a) continue;
                    BlockKey bk = this.getRenderBlock(new Coordinate(x, y, z), p.block);
                    if (!bk.equals(p.block)) {
                        this.access.data[x - this.array.getMinX()][y - this.array.getMinY()][z - this.array.getMinZ()] = new PositionData(bk.blockID, bk.metadata, p.tile);
                    }
                    this.renderer.func_147805_b(bk.blockID, x, y, z);
                }
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        for (x = this.array.getMinX(); x <= this.array.getMaxX(); ++x) {
            for (int y = this.array.getMinY(); y <= this.array.getMaxY(); ++y) {
                for (int z = this.array.getMinZ(); z <= this.array.getMaxZ(); ++z) {
                    p = this.access.getData(x, y, z);
                    if (p.tile == null || !p.useTESR) continue;
                    try {
                        ((PositionData)p).tile.field_145850_b = Minecraft.func_71410_x().field_71441_e;
                        TileEntityRendererDispatcher.field_147556_a.func_147549_a(p.tile, (double)x, (double)y, (double)z, ptick);
                        continue;
                    }
                    catch (Exception e) {
                        DragonAPICore.logError("Error rendering structure TileEntity @ " + x + ", " + y + ", " + z + ": " + p.tile);
                        e.printStackTrace();
                        p.useTESR = false;
                    }
                }
            }
        }
        tileRenderingReal = false;
        tileRendering = false;
        staticRenderAccess = null;
        for (Coordinate c : this.entities.keySet()) {
            EntityRender e = this.entities.get(c);
            e.renderer.func_76986_a(e.entity, (double)c.xCoord + 0.5, (double)c.yCoord + 0.5 + 0.375, (double)c.zCoord + 0.5, 0.0f, 0.0f);
            e.entity.func_70071_h_();
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public static RenderAccess getRenderAccess() {
        return staticRenderAccess;
    }

    public static class EntityRender {
        public final Entity entity;
        public final Render renderer;

        public EntityRender(Entity e) {
            this(e, ReikaEntityHelper.getEntityRenderer(e.getClass()));
        }

        public EntityRender(Entity e, Render r) {
            this.entity = e;
            this.renderer = r;
        }
    }

    public static interface BlockChoiceHook {
        public ItemStack getBlock(Coordinate var1, int var2);
    }

    public static interface BlockRenderHook {
        public double getScale();

        public int getOffsetX();

        public int getOffsetY();
    }

    protected static class RenderAccess
    implements IBlockAccess {
        protected final PositionData[][][] data;
        protected final Coordinate negativeCorner;
        protected final Coordinate offset;

        private RenderAccess(FilledBlockArray arr) {
            this.offset = new Coordinate(-arr.getMidX(), -arr.getMidY(), -arr.getMidZ());
            arr.offset(this.offset.xCoord, this.offset.yCoord, this.offset.zCoord);
            this.data = new PositionData[arr.getSizeX()][arr.getSizeY()][arr.getSizeZ()];
            this.negativeCorner = new Coordinate(arr.getMinX(), arr.getMinY(), arr.getMinZ());
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 0; j < this.data[i].length; ++j) {
                    for (int k = 0; k < this.data[i][j].length; ++k) {
                        TileEntity te;
                        int x = i + this.negativeCorner.xCoord;
                        int y = j + this.negativeCorner.yCoord;
                        int z = k + this.negativeCorner.zCoord;
                        Block b = arr.getBlockAt(x, y, z);
                        int m = arr.getMetaAt(x, y, z);
                        TileEntity te2 = arr.getTileEntityAt(x, y, z);
                        if (m < 0) {
                            m = 0;
                        }
                        TileEntity tileEntity = b != null ? (te2 != null ? te2 : b.createTileEntity((World)Minecraft.func_71410_x().field_71441_e, m)) : (te = null);
                        if (te != null) {
                            te.field_145851_c = x;
                            te.field_145848_d = y;
                            te.field_145849_e = z;
                        }
                        this.data[i][j][k] = b != null ? new PositionData(b, m, te) : new PositionData(Blocks.field_150350_a);
                    }
                }
            }
        }

        public Block func_147439_a(int x, int y, int z) {
            return ((PositionData)this.getData((int)x, (int)y, (int)z)).block.blockID;
        }

        public TileEntity func_147438_o(int x, int y, int z) {
            return this.getData(x, y, z).tile;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_72802_i(int x, int y, int z, int side) {
            return 0;
        }

        public int func_72805_g(int x, int y, int z) {
            return ((PositionData)this.getData((int)x, (int)y, (int)z)).block.metadata;
        }

        public int func_72879_k(int x, int y, int z, int side) {
            return 0;
        }

        public boolean func_147437_c(int x, int y, int z) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public BiomeGenBase func_72807_a(int x, int z) {
            return BiomeGenBase.field_76771_b;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_72800_K() {
            return 0;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_72806_N() {
            return false;
        }

        public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
            return ((PositionData)this.getData((int)x, (int)y, (int)z)).block.blockID.isSideSolid((IBlockAccess)this, x, y, z, side);
        }

        private PositionData getData(int x, int y, int z) {
            return this.inBounds(x -= this.negativeCorner.xCoord, y -= this.negativeCorner.yCoord, z -= this.negativeCorner.zCoord) ? this.data[x][y][z] : new PositionData(Blocks.field_150350_a);
        }

        private boolean inBounds(int x, int y, int z) {
            return x >= 0 && y >= 0 && z >= 0 && x < this.data.length && y < this.data[0].length && z < this.data[0][0].length;
        }
    }

    protected static class PositionData {
        private final BlockKey block;
        private final TileEntity tile;
        private boolean useTESR;

        private PositionData(Block b) {
            this(b, 0, null);
        }

        private PositionData(Block b, int meta) {
            this(b, meta, null);
        }

        protected PositionData(Block b, int meta, TileEntity te) {
            this.block = new BlockKey(b, meta);
            this.tile = te;
            this.useTESR = this.tile != null && TileEntityRendererDispatcher.field_147556_a.func_147547_b(this.tile) != null;
        }

        public String toString() {
            return this.block.toString() + "|" + this.tile;
        }
    }
}

