/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FXCollection {
    private final ArrayList<BasicFX> data = new ArrayList();

    public void addEffect(double x, double y, double z, IIcon ico, int life, float size, int color) {
        this.data.add(new BasicFX(x, y, z, ico, life, size, color));
    }

    public void update() {
        Iterator<BasicFX> it = this.data.iterator();
        while (it.hasNext()) {
            BasicFX fx = it.next();
            if (!fx.update()) continue;
            it.remove();
        }
    }

    public void render(boolean additive) {
        GL11.glPushAttrib((int)1048575);
        ReikaTextureHelper.bindTerrainTexture();
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        ReikaRenderHelper.disableEntityLighting();
        if (additive) {
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        } else {
            ReikaGLHelper.BlendMode.DEFAULT.apply();
        }
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78380_c(240);
        for (BasicFX fx : this.data) {
            fx.render(v5);
        }
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    private static class BasicFX {
        private final double posX;
        private final double posY;
        private final double posZ;
        private final int lifespan;
        private final int renderColor;
        private final float size;
        private final IIcon icon;
        private int ticks;

        private BasicFX(double x, double y, double z, IIcon ico, int life, float size, int color) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.lifespan = life;
            this.renderColor = color;
            this.size = size;
            this.icon = ico;
        }

        public boolean update() {
            ++this.ticks;
            return this.ticks >= this.lifespan;
        }

        private void render(Tessellator v5) {
            v5.func_78378_d(this.renderColor);
            float f1 = ActiveRenderInfo.field_74588_d;
            float f5 = ActiveRenderInfo.field_74589_e;
            float f2 = ActiveRenderInfo.field_74586_f;
            float f3 = ActiveRenderInfo.field_74587_g;
            float f4 = ActiveRenderInfo.field_74596_h;
            double fs = 0.1 * (double)this.size * Math.sin(Math.toRadians(180.0 * (double)this.ticks / (double)this.lifespan));
            float u = this.icon.func_94209_e();
            float v = this.icon.func_94206_g();
            float du = this.icon.func_94212_f();
            float dv = this.icon.func_94210_h();
            v5.func_78374_a(this.posX - (double)f1 * fs - (double)f3 * fs, this.posY - (double)f5 * fs, this.posZ - (double)f2 * fs - (double)f4 * fs, (double)du, (double)dv);
            v5.func_78374_a(this.posX - (double)f1 * fs + (double)f3 * fs, this.posY + (double)f5 * fs, this.posZ - (double)f2 * fs + (double)f4 * fs, (double)du, (double)v);
            v5.func_78374_a(this.posX + (double)f1 * fs + (double)f3 * fs, this.posY + (double)f5 * fs, this.posZ + (double)f2 * fs + (double)f4 * fs, (double)u, (double)v);
            v5.func_78374_a(this.posX + (double)f1 * fs - (double)f3 * fs, this.posY - (double)f5 * fs, this.posZ + (double)f2 * fs - (double)f4 * fs, (double)u, (double)dv);
        }
    }
}

