/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Instantiable.Event.Client.TextureReloadEvent;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TCharIntHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class BasicFontRenderer
extends FontRenderer
implements IResourceManagerReloadListener {
    private static final TCharIntHashMap charMap = new TCharIntHashMap(256);
    private static final TCharIntHashMap formatMap = new TCharIntHashMap(32);
    private static final ResourceLocation[] unicodePageLocations = new ResourceLocation[256];
    protected int[] field_78286_d = new int[256];
    public final int field_78288_b = 9;
    public Random field_78289_c = new Random();
    protected final byte[] field_78287_e = new byte[65536];
    protected final int[] field_78285_g = new int[32];
    protected float field_78295_j;
    protected float field_78296_k;
    private boolean unicodeFlag;
    protected boolean field_78294_m;
    protected float field_78291_n;
    protected float field_78292_o;
    protected float field_78306_p;
    protected float field_78305_q;
    protected int field_78304_r;
    protected boolean field_78303_s;
    protected boolean field_78302_t;
    protected boolean field_78301_u;
    protected boolean field_78300_v;
    protected boolean field_78299_w;
    protected Kerning kerning = Kerning.NORMAL;
    protected String currentString;
    private WipeEffect wipe;

    public BasicFontRenderer(boolean unicode) {
        super(Minecraft.func_71410_x().field_71474_y, ReikaTextureHelper.font, Minecraft.func_71410_x().field_71446_o, unicode);
        this.unicodeFlag = unicode;
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                int j1 = (k * 30 + l * 59 + i1 * 11) / 100;
                int k1 = (k * 30 + l * 70) / 100;
                int l1 = (k * 30 + i1 * 70) / 100;
                k = j1;
                l = k1;
                i1 = l1;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            this.field_78285_g[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
        this.readGlyphSizes();
    }

    @SubscribeEvent
    public final void reloadTextures(TextureReloadEvent evt) {
        this.onReload();
    }

    public final void func_110549_a(IResourceManager irm) {
        this.onReload();
    }

    protected void onReload() {
        this.func_111272_d();
    }

    protected abstract void func_111272_d();

    private void readGlyphSizes() {
        try {
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("font/glyph_sizes.bin")).func_110527_b();
            in.read(this.field_78287_e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected float renderCharAtPos(int charIndex, char c, boolean italic, int index) {
        if (this.wipe != null && this.wipe.lastChar == index + 1) {
            GL11.glColor4f((float)((float)ReikaColorAPI.getRed(this.wipe.wipeColor) / 255.0f), (float)((float)ReikaColorAPI.getGreen(this.wipe.wipeColor) / 255.0f), (float)((float)ReikaColorAPI.getBlue(this.wipe.wipeColor) / 255.0f), (float)((float)ReikaColorAPI.getAlpha(this.wipe.wipeColor) / 255.0f));
        } else {
            GL11.glColor4f((float)this.field_78291_n, (float)this.field_78292_o, (float)this.field_78306_p, (float)this.field_78305_q);
        }
        return c == ' ' ? 4.0f : (!this.unicodeFlag && charMap.contains(c) ? this.renderCharFraction(charIndex, italic, this.getFraction(index)) : this.func_78277_a(c, italic));
    }

    private float getFraction(int index) {
        return this.wipe != null && this.wipe.lastChar == index + 1 ? this.wipe.charFraction : 1.0f;
    }

    protected float func_78266_a(int charIndex, boolean italic) {
        return this.renderCharFraction(charIndex, italic, 1.0f);
    }

    protected float renderCharFraction(int charIndex, boolean italic, float fraction) {
        float f2;
        float columnPos = charIndex % 16 * 8;
        float rowPos = charIndex / 16 * 8;
        float f = f2 = italic ? 1.0f : 0.0f;
        if (this.needsGLBlending()) {
            GL11.glEnable((int)3042);
        }
        this.bindTexture();
        float f3 = (float)this.field_78286_d[charIndex] - 0.01f;
        float f4 = f3 * fraction;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(columnPos / 128.0f), (float)(rowPos / 128.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f2), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)(columnPos / 128.0f), (float)((rowPos + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.field_78295_j - f2), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((columnPos + f4 - 1.0f) / 128.0f), (float)(rowPos / 128.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f4 - 1.0f + f2), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)((columnPos + f4 - 1.0f) / 128.0f), (float)((rowPos + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f4 - 1.0f - f2), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glEnd();
        return this.field_78286_d[charIndex] + this.kerning.spaceModifier;
    }

    protected abstract void bindTexture();

    protected boolean needsGLBlending() {
        return false;
    }

    private ResourceLocation getUnicodePageLocation(int gl) {
        if (unicodePageLocations[gl] == null) {
            BasicFontRenderer.unicodePageLocations[gl] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", gl));
        }
        return unicodePageLocations[gl];
    }

    private void loadGlyphTexture(int gl) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getUnicodePageLocation(gl));
    }

    protected float func_78277_a(char c, boolean italic) {
        if (this.field_78287_e[c] == 0) {
            return 0.0f;
        }
        int i = c / 256;
        this.loadGlyphTexture(i);
        int j = this.field_78287_e[c] >>> 4;
        int k = this.field_78287_e[c] & 0xF;
        float f = j;
        float f1 = k + 1;
        float f2 = (float)(c % 16 * 16) + f;
        float f3 = (c & 0xFF) / 16 * 16;
        float f4 = f1 - f - 0.02f;
        float f5 = italic ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f5), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j - f5), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f4 / 2.0f + f5), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f4 / 2.0f - f5), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (f1 - f) / 2.0f + 1.0f;
    }

    public final int func_78261_a(String sg, int x, int y, int color) {
        return this.func_85187_a(sg, x, y, color, true);
    }

    public final int func_78276_b(String sg, int x, int y, int color) {
        return this.func_85187_a(sg, x, y, color, false);
    }

    public final int func_85187_a(String sg, int x, int y, int color, boolean shadow) {
        return this.doDrawString(sg, x, y, color, shadow);
    }

    public final int drawStringFloatPos(String sg, float x, float y, int color, boolean shadow) {
        this.wipe = null;
        return this.doDrawString(sg, x, y, color, shadow);
    }

    private int doDrawString(String sg, float x, float y, int color, boolean shadow) {
        int l;
        GL11.glEnable((int)3008);
        this.func_78265_b();
        if (shadow) {
            l = this.renderString(sg, x + 1.0f, y + 1.0f, color, true);
            l = Math.max(l, this.renderString(sg, x, y, color, false));
        } else {
            l = this.renderString(sg, x, y, color, false);
        }
        return l;
    }

    public final int drawFractionalString(String sg, int x, int y, int color, int cflash, boolean shadow, float fraction) {
        if (fraction >= 1.0f) {
            return this.func_85187_a(sg, x, y, color, shadow);
        }
        int len = sg.length();
        float fs = fraction * (float)len;
        float charFraction = ReikaMathLibrary.getDecimalPart(fs);
        int lastCharIndex = (int)fs + 1;
        this.wipe = new WipeEffect(charFraction, lastCharIndex, cflash);
        String sg2 = sg.substring(0, lastCharIndex);
        return this.doDrawString(sg2, x, y, color, shadow);
    }

    private String bidiReorder(String sg) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(sg), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException as) {
            return sg;
        }
    }

    protected void func_78265_b() {
        this.field_78303_s = false;
        this.field_78302_t = false;
        this.field_78301_u = false;
        this.field_78300_v = false;
        this.field_78299_w = false;
    }

    private void renderStringAtPos(String sg, boolean shadow) {
        this.currentString = sg;
        for (int i = 0; i < sg.length(); ++i) {
            if (!this.renderCharInString(sg, i, shadow)) continue;
            ++i;
        }
    }

    private int getFormatIndex(char c) {
        return formatMap.get(c);
    }

    protected boolean renderCharInString(String sg, int idx, boolean shadow) {
        boolean flag1;
        char c0 = sg.charAt(idx);
        if (c0 == '\u00a7' && idx + 1 < sg.length()) {
            int j = this.getFormatIndex(sg.toLowerCase().charAt(idx + 1));
            if (j < 16) {
                int k;
                this.field_78303_s = false;
                this.field_78302_t = false;
                this.field_78299_w = false;
                this.field_78300_v = false;
                this.field_78301_u = false;
                if (j < 0 || j > 15) {
                    j = 15;
                }
                if (shadow) {
                    j += 16;
                }
                this.field_78304_r = k = this.field_78285_g[j];
                GL11.glColor4f((float)((float)(k >> 16) / 255.0f), (float)((float)(k >> 8 & 0xFF) / 255.0f), (float)((float)(k & 0xFF) / 255.0f), (float)this.field_78305_q);
            } else if (j == 16) {
                this.field_78303_s = true;
            } else if (j == 17) {
                this.field_78302_t = true;
            } else if (j == 18) {
                this.field_78299_w = true;
            } else if (j == 19) {
                this.field_78300_v = true;
            } else if (j == 20) {
                this.field_78301_u = true;
            } else if (j == 21) {
                this.field_78303_s = false;
                this.field_78302_t = false;
                this.field_78299_w = false;
                this.field_78300_v = false;
                this.field_78301_u = false;
                GL11.glColor4f((float)this.field_78291_n, (float)this.field_78292_o, (float)this.field_78306_p, (float)this.field_78305_q);
            }
            ++idx;
            return true;
        }
        int j = BasicFontRenderer.getCharGridIndex(c0);
        if (this.field_78303_s && j != -1) {
            int k;
            while (this.field_78286_d[j] != this.field_78286_d[k = this.field_78289_c.nextInt(this.field_78286_d.length)]) {
            }
            j = k;
        }
        float f1 = this.unicodeFlag ? 0.5f : 1.0f;
        boolean bl = flag1 = (c0 == '\u0000' || j == -1 || this.unicodeFlag) && shadow;
        if (flag1) {
            this.field_78295_j -= f1;
            this.field_78296_k -= f1;
        }
        float f = this.renderCharAtPos(j, c0, this.field_78301_u, idx);
        if (flag1) {
            this.field_78295_j += f1;
            this.field_78296_k += f1;
        }
        if (this.field_78302_t) {
            this.field_78295_j += f1;
            if (flag1) {
                this.field_78295_j -= f1;
                this.field_78296_k -= f1;
            }
            this.renderCharAtPos(j, c0, this.field_78301_u, idx);
            this.field_78295_j -= f1;
            if (flag1) {
                this.field_78295_j += f1;
                this.field_78296_k += f1;
            }
            f += 1.0f;
        }
        Tessellator v5 = Tessellator.field_78398_a;
        if (this.field_78299_w) {
            GL11.glDisable((int)3553);
            v5.func_78382_b();
            v5.func_78377_a((double)this.field_78295_j, (double)(this.field_78296_k + 4.0f), 0.0);
            v5.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + 4.0f), 0.0);
            v5.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + 4.0f - 1.0f), 0.0);
            v5.func_78377_a((double)this.field_78295_j, (double)(this.field_78296_k + 4.0f - 1.0f), 0.0);
            v5.func_78381_a();
            GL11.glEnable((int)3553);
        }
        if (this.field_78300_v) {
            GL11.glDisable((int)3553);
            v5.func_78382_b();
            int l = this.field_78300_v ? -1 : 0;
            v5.func_78377_a((double)(this.field_78295_j + (float)l), (double)(this.field_78296_k + 9.0f), 0.0);
            v5.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + 9.0f), 0.0);
            v5.func_78377_a((double)(this.field_78295_j + f), (double)(this.field_78296_k + 9.0f - 1.0f), 0.0);
            v5.func_78377_a((double)(this.field_78295_j + (float)l), (double)(this.field_78296_k + 9.0f - 1.0f), 0.0);
            v5.func_78381_a();
            GL11.glEnable((int)3553);
        }
        this.field_78295_j += (float)((int)f);
        return false;
    }

    private int renderStringAligned(String sg, int x, int y, int p_78274_4_, int color, boolean shadow) {
        if (this.field_78294_m) {
            int i1 = this.func_78256_a(this.bidiReorder(sg));
            x = x + p_78274_4_ - i1;
        }
        return this.renderString(sg, x, y, color, shadow);
    }

    private int renderString(String sg, float x, float y, int color, boolean shadow) {
        if (sg == null) {
            return 0;
        }
        if (this.field_78294_m) {
            sg = this.bidiReorder(sg);
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (shadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        this.field_78291_n = (float)(color >> 16 & 0xFF) / 255.0f;
        this.field_78292_o = (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_78306_p = (float)(color & 0xFF) / 255.0f;
        this.field_78305_q = (float)(color >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)this.field_78291_n, (float)this.field_78292_o, (float)this.field_78306_p, (float)this.field_78305_q);
        this.field_78295_j = x;
        this.field_78296_k = y;
        this.renderStringAtPos(sg, shadow);
        return (int)this.field_78295_j;
    }

    public final int func_78256_a(String sg) {
        if (sg == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < sg.length(); ++j) {
            char c0 = sg.charAt(j);
            int k = this.func_78263_a(c0);
            if (k < 0 && j < sg.length() - 1) {
                if ((c0 = sg.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag || k <= 0) continue;
            ++i;
        }
        return i;
    }

    public int func_78263_a(char c) {
        if (c == '\u00a7') {
            return -1;
        }
        if (c == ' ') {
            return 4;
        }
        int i = BasicFontRenderer.getCharGridIndex(c);
        if (c > '\u0000' && i != -1 && !this.unicodeFlag) {
            return this.field_78286_d[i];
        }
        if (this.field_78287_e[c] != 0) {
            int j = this.field_78287_e[c] >>> 4;
            int k = this.field_78287_e[c] & 0xF;
            if (k > 7) {
                k = 15;
                j = 0;
            }
            return (++k - j) / 2 + 1;
        }
        return 0;
    }

    public String func_78269_a(String sg, int width) {
        return this.func_78262_a(sg, width, false);
    }

    public String func_78262_a(String sg, int width, boolean rev) {
        StringBuilder stringbuilder = new StringBuilder();
        int j = 0;
        int k = rev ? sg.length() - 1 : 0;
        int l = rev ? -1 : 1;
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i1 = k; i1 >= 0 && i1 < sg.length() && j < width; i1 += l) {
            char c0 = sg.charAt(i1);
            int j1 = this.func_78263_a(c0);
            if (flag1) {
                flag1 = false;
                if (c0 != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag2 = false;
                    }
                } else {
                    flag2 = true;
                }
            } else if (j1 < 0) {
                flag1 = true;
            } else {
                j += j1;
                if (flag2) {
                    ++j;
                }
            }
            if (j > width) break;
            if (rev) {
                stringbuilder.insert(0, c0);
                continue;
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    private String trimStringNewline(String sg) {
        while (sg != null && sg.endsWith("\n")) {
            sg = sg.substring(0, sg.length() - 1);
        }
        return sg;
    }

    public final void func_78279_b(String sg, int x, int y, int color, int width) {
        this.func_78265_b();
        this.field_78304_r = width;
        sg = this.trimStringNewline(sg);
        this.wipe = null;
        this.renderSplitString(sg, x, y, color, false);
    }

    private void renderSplitString(String sg, int x, int y, int color, boolean shadow) {
        List<String> list = this.func_78271_c(sg, color);
        for (String s1 : list) {
            this.renderStringAligned(s1, x, y, color, this.field_78304_r, shadow);
            y += 9;
        }
    }

    public int func_78267_b(String sg, int width) {
        return 9 * this.func_78271_c(sg, width).size();
    }

    public void func_78264_a(boolean uni) {
        this.unicodeFlag = uni;
    }

    public boolean func_82883_a() {
        return this.unicodeFlag;
    }

    public void func_78275_b(boolean bidi) {
        this.field_78294_m = bidi;
    }

    public final List<String> func_78271_c(String sg, int width) {
        return Arrays.asList(this.wrapFormattedString(sg, width).split("\n"));
    }

    private String wrapFormattedString(String sg, int width) {
        int j = this.sizeStringToWidth(sg, width);
        if (sg.length() <= j) {
            return sg;
        }
        String s1 = sg.substring(0, j);
        char c0 = sg.charAt(j);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s2 = BasicFontRenderer.getFormatFromString(s1) + sg.substring(j + (flag ? 1 : 0));
        return s1 + "\n" + this.wrapFormattedString(s2, width);
    }

    private int sizeStringToWidth(String sg, int w) {
        int l;
        int j = sg.length();
        int k = 0;
        int i1 = -1;
        boolean flag = false;
        for (l = 0; l < j; ++l) {
            char c0 = sg.charAt(l);
            switch (c0) {
                case '\n': {
                    --l;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (l >= j - 1) break;
                    if ((c1 = sg.charAt(++l)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !BasicFontRenderer.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                    break;
                }
                case ' ': {
                    i1 = l;
                }
                default: {
                    k += this.func_78263_a(c0);
                    if (!flag) break;
                    ++k;
                }
            }
            if (c0 == '\n') {
                i1 = ++l;
                break;
            }
            if (k > w) break;
        }
        return l != j && i1 != -1 && i1 < l ? i1 : l;
    }

    private static boolean isFormatColor(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isFormatSpecial(char c) {
        return c >= 'k' && c <= 'o' || c >= 'K' && c <= 'O' || c == 'r' || c == 'R';
    }

    private static String getFormatFromString(String sg) {
        String s1 = "";
        int i = -1;
        int j = sg.length();
        while ((i = sg.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c0 = sg.charAt(i + 1);
            if (BasicFontRenderer.isFormatColor(c0)) {
                s1 = "\u00a7" + c0;
                continue;
            }
            if (!BasicFontRenderer.isFormatSpecial(c0)) continue;
            s1 = s1 + "\u00a7" + c0;
        }
        return s1;
    }

    public boolean func_78260_a() {
        return this.field_78294_m;
    }

    protected static int getCharGridIndex(char c) {
        return charMap.get(c);
    }

    static {
        String key = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            charMap.put(chars[i], i);
        }
        String form = "0123456789abcdefklmnor";
        chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            formatMap.put(chars[i], i);
        }
    }

    private static class WipeEffect {
        private final int lastChar;
        private final float charFraction;
        private final int wipeColor;

        private WipeEffect(float f, int ch, int color) {
            this.lastChar = ch;
            this.charFraction = f;
            this.wipeColor = color;
        }
    }

    public static enum Kerning {
        VERYNARROW(-2),
        NARROW(-1),
        NORMAL(0),
        WIDE(1),
        VERYWIDE(2);

        public final int spaceModifier;

        private Kerning(int s) {
            this.spaceModifier = s;
        }
    }
}

