/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ParticleController;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Spline;
import Reika.DragonAPI.Interfaces.PositionController;
import java.util.List;
import net.minecraft.entity.Entity;

public class SplineMotionController
implements PositionController {
    public final DecimalPosition pos1;
    public final DecimalPosition pos2;
    public final int entityLife;
    private int tick = 0;
    private boolean updateSpline = false;
    private final Spline spline;
    private List<DecimalPosition> points;

    public SplineMotionController(double x1, double y1, double z1, double x2, double y2, double z2, int l, Spline s) {
        this.pos1 = new DecimalPosition(x1, y1, z1);
        this.pos2 = new DecimalPosition(x2, y2, z2);
        this.entityLife = l;
        this.spline = s;
        this.points = this.spline.get(32, false);
    }

    public SplineMotionController(double x1, double y1, double z1, double x2, double y2, double z2, int l, double var, double vel) {
        this.pos1 = new DecimalPosition(x1, y1, z1);
        this.pos2 = new DecimalPosition(x2, y2, z2);
        this.entityLife = l;
        this.spline = new Spline(Spline.SplineType.CHORDAL);
        for (double d = 0.0; d <= 1.0; d += 0.125) {
            Spline.BasicVariablePoint p = new Spline.BasicVariablePoint(DecimalPosition.interpolate(this.pos1, this.pos2, d), var, vel);
            p.tolerance *= 0.03125;
            this.spline.addPoint(p);
        }
        this.updateSpline = true;
        this.points = this.spline.get(32, false);
    }

    @Override
    public void update(Entity e) {
        if (this.updateSpline) {
            this.spline.update();
        }
        this.points = this.spline.get(32, false);
        ++this.tick;
    }

    private int getIndex(Entity e) {
        int t = this.tick * this.points.size() / this.entityLife;
        return Math.min(t, this.points.size() - 1);
    }

    @Override
    public double getPositionX(Entity e) {
        return this.points.get((int)this.getIndex((Entity)e)).xCoord;
    }

    @Override
    public double getPositionY(Entity e) {
        return this.points.get((int)this.getIndex((Entity)e)).yCoord;
    }

    @Override
    public double getPositionZ(Entity e) {
        return this.points.get((int)this.getIndex((Entity)e)).zCoord;
    }
}

