/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MusicScore {
    private final TreeMap<Integer, Note>[] music;
    private final int channelCount;
    private int length;

    public MusicScore(int channels) {
        this.channelCount = channels;
        this.music = new TreeMap[channels];
    }

    public void addNote(int time, int channel, ReikaMusicHelper.MusicKey note, int voice, int vol, int len) {
        this.addNote(channel, time, new Note(note, voice, vol, len));
    }

    private void addNote(int channel, int time, Note note) {
        if (this.music[channel] == null) {
            this.music[channel] = new TreeMap();
        }
        this.music[channel].put(time, note);
        this.length = Math.max(this.length, time);
    }

    public ArrayList<Note> getNotes(int time) {
        ArrayList<Note> li = new ArrayList<Note>();
        for (int i = 0; i < this.channelCount; ++i) {
            Note n;
            Note note = n = this.music[i] != null ? this.music[i].get(time) : null;
            if (n == null) continue;
            li.add(n);
        }
        return li;
    }

    public Note getNote(int channel, int time) {
        return this.music[channel] != null ? this.music[channel].get(time) : null;
    }

    public Map<Integer, Note> getTrack(int channel) {
        return this.music[channel] != null ? Collections.unmodifiableMap(this.music[channel]) : new HashMap<Integer, Note>();
    }

    public int getLatestPos(int channel) {
        return this.music[channel] != null && !this.music[channel].isEmpty() ? this.music[channel].lastKey() : 0;
    }

    public int getLatestPos() {
        return this.length;
    }

    public MusicScore scaleSpeed(float factor) {
        MusicScore mus = new MusicScore(this.channelCount);
        for (int i = 0; i < this.channelCount; ++i) {
            if (this.music[i] == null) continue;
            for (int time : this.music[i].keySet()) {
                Note n = this.music[i].get(time);
                mus.addNote(i, (int)((float)time / factor), n);
            }
        }
        return mus;
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.channelCount; ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.music[i] != null) {
                for (int time : this.music[i].keySet()) {
                    NBTTagCompound val = new NBTTagCompound();
                    this.music[i].get(time).writeToNBT(val);
                    nbt.func_74782_a(String.valueOf(time), (NBTBase)val);
                }
            }
            tag.func_74782_a("Ch_" + i, (NBTBase)nbt);
        }
        tag.func_74768_a("numchan", this.channelCount);
    }

    public static MusicScore readFromNBT(NBTTagCompound tag) {
        MusicScore mus = new MusicScore(tag.func_74762_e("numchan"));
        for (int i = 0; i < mus.channelCount; ++i) {
            if (!tag.func_74764_b("Ch_" + i)) continue;
            mus.music[i] = new TreeMap();
            NBTTagCompound nbt = tag.func_74775_l("Ch_" + i);
            for (Object o : nbt.func_150296_c()) {
                String s = (String)o;
                NBTTagCompound val = nbt.func_74775_l(s);
                mus.music[i].put(Integer.parseInt(s), Note.readFromNBT(val));
            }
        }
        return mus;
    }

    public String toString() {
        return Arrays.toString(this.music);
    }

    public void clearChannel(int channel) {
        this.music[channel] = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPianoRoll() {
    }

    public MusicScore copy() {
        MusicScore mus = new MusicScore(this.channelCount);
        for (int i = 0; i < this.channelCount; ++i) {
            if (this.music[i] == null) continue;
            mus.music[i] = new TreeMap();
            mus.music[i].putAll(this.music[i]);
        }
        mus.length = this.length;
        return mus;
    }

    public static class Note {
        public final ReikaMusicHelper.MusicKey key;
        public final int voice;
        public final int volume;
        public final int length;

        private Note(ReikaMusicHelper.MusicKey note, int instru, int vol, int len) {
            this.key = note;
            this.voice = instru;
            this.volume = vol;
            this.length = len;
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("key", this.key.ordinal());
            nbt.func_74768_a("volume", this.volume);
            nbt.func_74768_a("voice", this.voice);
            nbt.func_74768_a("length", this.length);
        }

        public static Note readFromNBT(NBTTagCompound nbt) {
            return new Note(ReikaMusicHelper.MusicKey.getByIndex(nbt.func_74762_e("key")), nbt.func_74762_e("voice"), nbt.func_74762_e("volume"), nbt.func_74762_e("length"));
        }

        public String toString() {
            return this.key.name() + "/" + this.voice + "/" + this.volume;
        }

        public int hashCode() {
            return this.key.ordinal() << 16 | this.voice << 8 | this.volume;
        }

        public boolean equals(Object o) {
            if (o instanceof Note) {
                Note n = (Note)o;
                return n.key == this.key && n.voice == this.voice && n.volume == this.volume;
            }
            return false;
        }
    }
}

