/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.IO.ReikaXMLBase;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLInterface {
    private Document doc;
    private final Class rootClass;
    private final String filepath;
    private final boolean requireFile;
    private final HashMap<String, String> data;
    private final MultiMap<String, String> tree;
    public static final String NULL_VALUE = "#NULL!";

    public XMLInterface(Class root, String path) {
        this(root, path, false);
    }

    public XMLInterface(Class root, String path, boolean crashIfNull) {
        block2: {
            this.data = new HashMap();
            this.tree = new MultiMap();
            this.rootClass = root;
            this.filepath = path;
            this.requireFile = crashIfNull;
            try {
                this.doc = ReikaXMLBase.getXMLDocument(root, path);
            }
            catch (RuntimeException e) {
                if (!this.requireFile) break block2;
                throw new RuntimeException(e);
            }
        }
        this.readFileToMap();
    }

    public void reread() {
        block2: {
            try {
                this.doc = ReikaXMLBase.getXMLDocument(this.rootClass, this.filepath);
                this.readFileToMap();
            }
            catch (RuntimeException e) {
                if (!this.requireFile) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    private void readFileToMap() {
        this.recursiveRead("$TOP$", this.doc);
    }

    private void recursiveRead(String parent, Node n) {
        if (n == null) {
            return;
        }
        NodeList li = n.getChildNodes();
        int len = li.getLength();
        for (int i = 0; i < len; ++i) {
            Node ch = li.item(i);
            String key = ReikaXMLBase.getNodeNameTree(ch);
            this.tree.addValue(parent, key);
            if (ch.getNodeType() == 1) {
                this.recursiveRead(key, ch);
                continue;
            }
            if (ch.getNodeType() != 3) continue;
            String val = ch.getNodeValue();
            if (val != null) {
                if (val.equals("\n")) {
                    val = null;
                } else {
                    if (val.startsWith("\n")) {
                        val = val.substring(1);
                    }
                    if (val.endsWith("\n")) {
                        val = val.substring(0, val.length() - 1);
                    }
                }
                if (val != null && val.equals("\n")) {
                    val = null;
                }
            }
            if (val == null) continue;
            val = val.replace("\t", "");
            if (this.data.containsKey(key)) {
                // empty if block
            }
            this.data.put(key, val);
        }
    }

    public String getValueAtNode(String name) {
        String dat = this.data.get(name);
        if (dat == null) {
            dat = NULL_VALUE;
        }
        return dat;
    }

    public boolean nodeExists(String name) {
        return this.data.containsKey(name);
    }

    public Collection<String> getNodesWithin(String name) {
        return name == null ? this.getTopNodes() : this.tree.get(name);
    }

    public Collection<String> getTopNodes() {
        return this.tree.get("$TOP$");
    }

    public String toString() {
        return this.data.toString();
    }
}

