/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class SimpleConfig {
    private Configuration config;
    private File configFile;
    private final DragonAPIMod configMod;
    private final HashMap<String, Object> data = new HashMap();
    private boolean isReading = false;

    public SimpleConfig(DragonAPIMod mod) {
        if (mod == null) {
            throw new MisuseException("You cannot create a config with a null mod!");
        }
        this.configMod = mod;
    }

    public void loadCustomConfigFile(FMLPreInitializationEvent event, String file) {
        this.configFile = new File(file);
    }

    public void loadSubfolderedConfigFile(FMLPreInitializationEvent event) {
        String name = ReikaStringParser.stripSpaces(this.configMod.getDisplayName());
        String author = ReikaStringParser.stripSpaces(this.configMod.getModAuthorName());
        String file = event.getModConfigurationDirectory() + "/" + author + "/" + name + ".cfg";
        this.configFile = new File(file);
    }

    public void loadDefaultConfigFile(FMLPreInitializationEvent event) {
        this.configFile = event.getSuggestedConfigurationFile();
    }

    public final void loadDataFromFile(FMLPreInitializationEvent event) {
        if (this.isReading) {
            throw new MisuseException("Already reading!");
        }
        if (this.configFile == null) {
            throw new MisuseException("Error loading " + this.configMod.getDisplayName() + ": You must load a config file before reading it!");
        }
        this.config = new Configuration(this.configFile);
        this.config.load();
        this.isReading = true;
    }

    public final void finishReading() {
        if (!this.isReading) {
            throw new MisuseException("You cannot stop reading before you start!");
        }
        this.config.save();
        this.isReading = false;
    }

    public int getInteger(String category, String key, int defaultValue) {
        boolean flag;
        boolean bl = flag = !this.isReading;
        if (this.data.containsKey(key)) {
            return (Integer)this.data.get(key);
        }
        if (flag) {
            this.loadIfNecessary();
        }
        int param = this.config.get(category, key, defaultValue).getInt();
        this.data.put(key, param);
        if (flag) {
            this.saveIfNecessary();
        }
        return param;
    }

    public float getFloat(String category, String key, float defaultValue) {
        boolean flag;
        boolean bl = flag = !this.isReading;
        if (this.data.containsKey(key)) {
            return ((Double)this.data.get(key)).floatValue();
        }
        if (flag) {
            this.loadIfNecessary();
        }
        double param = this.config.get(category, key, (double)defaultValue).getDouble();
        this.data.put(key, param);
        if (flag) {
            this.saveIfNecessary();
        }
        return (float)param;
    }

    public boolean getBoolean(String category, String key, boolean defaultValue) {
        boolean flag;
        boolean bl = flag = !this.isReading;
        if (this.data.containsKey(key)) {
            return (Boolean)this.data.get(key);
        }
        if (flag) {
            this.loadIfNecessary();
        }
        boolean param = this.config.get(category, key, defaultValue).getBoolean(defaultValue);
        this.data.put(key, param);
        if (flag) {
            this.saveIfNecessary();
        }
        return param;
    }

    public ArrayList<Integer> getIntList(String category, String key, int ... defaults) {
        boolean flag;
        boolean bl = flag = !this.isReading;
        if (this.data.containsKey(key)) {
            return (ArrayList)this.data.get(key);
        }
        if (flag) {
            this.loadIfNecessary();
        }
        ArrayList<Integer> param = this.getList(this.config.get(category, key, defaults));
        this.data.put(key, param);
        if (flag) {
            this.saveIfNecessary();
        }
        return param;
    }

    private ArrayList<Integer> getList(Property p) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        int[] data = p.getIntList();
        for (int i = 0; i < data.length; ++i) {
            li.add(data[i]);
        }
        return li;
    }

    private void loadIfNecessary() {
        if (!this.isReading) {
            this.config.load();
            this.isReading = true;
        }
    }

    private void saveIfNecessary() {
        if (this.isReading) {
            this.isReading = false;
            this.config.save();
        }
    }
}

