/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.ModLogger;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketPipeline {
    private ArrayList<Class<? extends ReikaPacketHelper.PacketObj>> packets = new ArrayList();
    private boolean isPostInitialized = false;
    private final DragonAPIMod mod;
    public final String packetChannel;
    private final PacketHandler handler;
    private final SimpleNetworkWrapper wrapper;

    public PacketPipeline(DragonAPIMod mod, String modChannel, PacketHandler handler, SimpleNetworkWrapper wrapper) {
        this.packetChannel = modChannel;
        this.mod = mod;
        this.handler = handler;
        this.wrapper = wrapper;
    }

    public void registerPacket(Class<? extends ReikaPacketHelper.PacketObj> cl) {
        int id = this.packets.size();
        this.wrapper.registerMessage(InternalHandler.class, cl, id, Side.SERVER);
        this.wrapper.registerMessage(InternalHandler.class, cl, id, Side.CLIENT);
    }

    public PacketHandler getHandler() {
        return this.handler;
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAllOnServer(ReikaPacketHelper.PacketObj p) {
        this.wrapper.sendToAll((IMessage)p);
    }

    public Packet getMinecraftPacket(ReikaPacketHelper.PacketObj p) {
        return this.wrapper.getPacketFrom((IMessage)p);
    }

    public void sendToPlayer(ReikaPacketHelper.PacketObj p, EntityPlayerMP player) {
        if (player == null) {
            throw new MisuseException("You cannot send a packet to a null player!");
        }
        if (ReikaPlayerAPI.isFake((EntityPlayer)player)) {
            throw new MisuseException("You cannot send a packet to a fake player!");
        }
        this.wrapper.sendTo((IMessage)p, player);
    }

    public void sendToAllAround(ReikaPacketHelper.PacketObj p, TileEntity te, double range) {
        this.sendToAllAround(p, new WorldLocation(te), range);
    }

    public void sendToAllAround(ReikaPacketHelper.PacketObj p, World world, double x, double y, double z, double range) {
        this.sendToAllAround(p, world.field_73011_w.field_76574_g, x, y, z, range);
    }

    public void sendToAllAround(ReikaPacketHelper.PacketObj p, int world, double x, double y, double z, double range) {
        NetworkRegistry.TargetPoint pt = new NetworkRegistry.TargetPoint(world, x, y, z, range);
        this.wrapper.sendToAllAround((IMessage)p, pt);
    }

    public void sendToAllAround(ReikaPacketHelper.PacketObj p, Entity e, double range) {
        NetworkRegistry.TargetPoint pt = new NetworkRegistry.TargetPoint(e.field_70170_p.field_73011_w.field_76574_g, e.field_70165_t, e.field_70163_u, e.field_70161_v, range);
        this.wrapper.sendToAllAround((IMessage)p, pt);
    }

    public void sendToAllAround(ReikaPacketHelper.PacketObj p, WorldLocation loc, double range) {
        NetworkRegistry.TargetPoint pt = new NetworkRegistry.TargetPoint(loc.dimensionID, (double)loc.xCoord, (double)loc.yCoord, (double)loc.zCoord, range);
        this.wrapper.sendToAllAround((IMessage)p, pt);
    }

    public void sendToDimension(ReikaPacketHelper.PacketObj p, World world) {
        this.sendToDimension(p, world.field_73011_w.field_76574_g);
    }

    public void sendToDimension(ReikaPacketHelper.PacketObj p, int dimensionId) {
        this.wrapper.sendToDimension((IMessage)p, dimensionId);
    }

    public void sendToServer(ReikaPacketHelper.PacketObj p) {
        this.wrapper.sendToServer((IMessage)p);
    }

    public ModLogger getLogger() {
        return this.mod.getModLogger();
    }

    public static class InternalHandler
    implements IMessageHandler<ReikaPacketHelper.PacketObj, IMessage> {
        public IMessage onMessage(ReikaPacketHelper.PacketObj message, MessageContext ctx) {
            switch (ctx.side) {
                case CLIENT: {
                    message.handleClient(ctx.getClientHandler());
                    break;
                }
                case SERVER: {
                    message.handleServer(ctx.getServerHandler());
                }
            }
            return null;
        }
    }
}

