/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class NBTFile {
    public final String name;
    private final String filepath;
    private final Class reference;
    public boolean compressData = false;
    public boolean encryptData = false;

    public NBTFile(File f) {
        this(f.getName(), f.getAbsolutePath(), null);
    }

    public NBTFile(String name, String path, Class c) {
        this.name = name;
        this.filepath = path;
        this.reference = c;
    }

    private InputStream encryptStreamData(InputStream in, boolean unpack) throws IOException {
        ArrayList<Byte> data = new ArrayList<Byte>();
        int dat = in.read();
        while (dat != -1) {
            data.add((byte)dat);
            dat = in.read();
        }
        in.close();
        Collections.reverse(data);
        byte[] arr = new byte[data.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Byte)data.get(i);
        }
        return new ByteArrayInputStream(arr);
    }

    private void encryptFileData(File f, boolean unpack) throws IOException {
        FileInputStream in = new FileInputStream(f);
        ArrayList<Byte> data = new ArrayList<Byte>();
        int dat = ((InputStream)in).read();
        while (dat != -1) {
            data.add((byte)dat);
            dat = ((InputStream)in).read();
        }
        ((InputStream)in).close();
        Collections.reverse(data);
        FileOutputStream out = new FileOutputStream(f);
        Iterator i$ = data.iterator();
        while (i$.hasNext()) {
            byte b = (Byte)i$.next();
            ((OutputStream)out).write(b);
        }
        out.flush();
        ((OutputStream)out).close();
    }

    public final void load() throws IOException {
        if (this.reference != null) {
            InputStream in = this.reference.getResourceAsStream(this.filepath);
            if (this.encryptData) {
                in = this.encryptStreamData(in, true);
            }
            NBTTagCompound tag = this.compressData ? CompressedStreamTools.func_74796_a((InputStream)in) : ReikaFileReader.readUncompressedNBT(in);
            this.setDataFromLines(tag);
        } else {
            File f = new File(this.filepath);
            if (!f.exists()) {
                return;
            }
            if (this.encryptData) {
                this.encryptFileData(f, true);
            }
            NBTTagCompound tag = this.compressData ? CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(f)) : ReikaFileReader.readUncompressedNBT(f);
            this.setDataFromLines(tag);
        }
    }

    public final void save() throws IOException {
        File f = new File(this.filepath);
        f.getParentFile().mkdirs();
        f.delete();
        f.createNewFile();
        NBTTagCompound tag = this.getDataAsLines();
        if (this.compressData) {
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)new FileOutputStream(f));
        } else {
            ReikaFileReader.writeUncompressedNBT(tag, f);
        }
        if (this.encryptData) {
            this.encryptFileData(f, false);
        }
    }

    private NBTTagCompound getDataAsLines() {
        NBTTagCompound dat = new NBTTagCompound();
        NBTTagCompound header = new NBTTagCompound();
        this.writeHeader(header);
        NBTTagCompound extra = this.writeExtraData();
        if (extra != null) {
            header.func_74782_a("extra", (NBTBase)extra);
        }
        dat.func_74782_a("header", (NBTBase)header);
        NBTTagList li = new NBTTagList();
        this.writeData(li);
        dat.func_74782_a("data", (NBTBase)li);
        return dat;
    }

    private void setDataFromLines(NBTTagCompound tag) {
        NBTTagCompound header = tag.func_74775_l("header");
        this.readHeader(header);
        NBTTagCompound extra = header.func_74775_l("extra");
        this.readExtraData(extra);
        NBTTagList li = tag.func_150295_c("data", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        this.readData(li);
    }

    protected abstract void readHeader(NBTTagCompound var1);

    protected abstract void readData(NBTTagList var1);

    protected abstract void readExtraData(NBTTagCompound var1);

    protected abstract void writeHeader(NBTTagCompound var1);

    protected abstract void writeData(NBTTagList var1);

    protected abstract NBTTagCompound writeExtraData();
}

