/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Formula;

import Reika.DragonAPI.Instantiable.Formula.MathExpression;

public class PowerExpression
extends MathExpression {
    public final double baseVal;
    public final double scale;
    public final double power;

    public PowerExpression(double init, double scale, double power) {
        this.baseVal = init;
        this.scale = scale;
        this.power = power;
    }

    @Override
    public final double evaluate(double arg) throws ArithmeticException {
        return this.baseVal + this.scale * Math.pow(arg, this.power);
    }

    @Override
    public final double getBaseValue() {
        return this.baseVal;
    }

    @Override
    public final String toString() {
        return this.baseVal + (this.scale > 0.0 ? "+" : "-") + Math.abs(this.scale) + "*base^" + this.power;
    }
}

