/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Formula;

import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import java.util.TreeMap;

public abstract class PiecewiseExpression
extends MathExpression {
    private final TreeMap<Range, MathExpression> data = new TreeMap();

    protected final void addComponent(double min, boolean inclmin, double max, boolean inclmax, MathExpression exp) {
        this.data.put(new Range(min, max, inclmin, inclmax), exp);
    }

    @Override
    public double getBaseValue() {
        return Double.NaN;
    }

    @Override
    public final double evaluate(double arg) {
        Range r = this.getRangeFor(arg);
        MathExpression exp = r != null ? this.data.get(r) : null;
        return exp != null ? exp.evaluate(arg) : Double.NaN;
    }

    private Range getRangeFor(double arg) {
        for (Range r : this.data.keySet()) {
            if (!r.contains(arg)) continue;
            return r;
        }
        return null;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Range r : this.data.keySet()) {
            sb.append(r.toString());
            sb.append("=");
            sb.append(this.data.get(r).toString());
            sb.append(";");
        }
        sb.append("}");
        return sb.toString();
    }

    private static class Range
    implements Comparable<Range> {
        private final double lowerLimit;
        private final double upperLimit;
        private final boolean inclLower;
        private final boolean inclUpper;

        private Range(double l, double h, boolean il, boolean iu) {
            this.lowerLimit = l;
            this.upperLimit = h;
            this.inclLower = il;
            this.inclUpper = iu;
        }

        public boolean contains(double arg) {
            if (arg > this.lowerLimit && arg < this.upperLimit) {
                return true;
            }
            if (arg == this.lowerLimit) {
                return this.inclLower;
            }
            if (arg == this.upperLimit) {
                return this.inclUpper;
            }
            return false;
        }

        @Override
        public int compareTo(Range o) {
            return (int)(this.lowerLimit * 100.0);
        }

        public int hashCode() {
            return (int)(this.lowerLimit * 100.0) ^ (int)(this.upperLimit * 100.0) + (this.inclLower ? 50000 : 0) + (this.inclUpper ? 1000000 : 0);
        }

        public boolean equals(Object o) {
            if (o instanceof Range) {
                Range r = (Range)o;
                return r.lowerLimit == this.lowerLimit && r.upperLimit == this.upperLimit && r.inclLower == this.inclLower && r.inclUpper == this.inclUpper;
            }
            return false;
        }

        public final String toString() {
            return (this.inclLower ? "[" : "(") + this.lowerLimit + "," + this.upperLimit + (this.inclUpper ? "]" : ")");
        }
    }
}

