/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public final class ScheduledTickEvent
extends Event
implements TimerMap.TimerCallback {
    private final ScheduledEvent action;

    public ScheduledTickEvent(ScheduledEvent evt) {
        this.action = evt;
    }

    public final void fire() {
        MinecraftForge.EVENT_BUS.post((Event)this);
        this.action.fire();
    }

    @Override
    public void call() {
        if (this.action.runOnSide(FMLCommonHandler.instance().getEffectiveSide())) {
            this.fire();
        }
    }

    public static interface ScheduledEvent {
        public void fire();

        public boolean runOnSide(Side var1);
    }

    public static class ScheduledSoundEvent
    implements ScheduledEvent {
        private final SoundEnum sound;
        private final float volume;
        private final float pitch;
        private World world;
        private double posX;
        private double posY;
        private double posZ;
        private Entity entity;

        private ScheduledSoundEvent(SoundEnum s, float v, float p) {
            this.sound = s;
            this.volume = v;
            this.pitch = p;
        }

        public ScheduledSoundEvent(SoundEnum s, Entity e, float v, float p) {
            this(s, v, p);
            this.entity = e;
        }

        public ScheduledSoundEvent(SoundEnum s, World w, double x, double y, double z, float v, float p) {
            this(s, v, p);
            this.world = w;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        @Override
        public void fire() {
            this.sound.playSound(this.getWorld(), this.getX(), this.getY(), this.getZ(), this.volume, this.pitch);
        }

        protected Entity getEntity() {
            return this.entity;
        }

        private World getWorld() {
            return this.entity != null ? this.entity.field_70170_p : this.world;
        }

        private double getX() {
            return this.entity != null ? this.entity.field_70165_t : this.posX;
        }

        private double getY() {
            return this.entity != null ? this.entity.field_70163_u : this.posY;
        }

        private double getZ() {
            return this.entity != null ? this.entity.field_70161_v : this.posZ;
        }

        @Override
        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }
    }
}

