/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenMutated;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.common.MinecraftForge;

@Cancelable
public class BiomeMutationEvent
extends Event {
    public final GenLayer generator;
    public final int posX;
    public final int posZ;
    public final int originalBiomeID;
    public final int originalMutatedID;

    public BiomeMutationEvent(GenLayer gen, int x, int z, int id) {
        this.generator = gen;
        this.posX = x;
        this.posZ = z;
        this.originalBiomeID = id;
        this.originalMutatedID = id + 128;
    }

    public static boolean fireTry(GenLayer gen, int chunkX, int chunkZ, int x, int z, int originalID) {
        BiomeMutationEvent evt = new BiomeMutationEvent(gen, (chunkX << 4) + x, (chunkZ << 4) + z, originalID);
        return !MinecraftForge.EVENT_BUS.post((Event)evt) && BiomeGenBase.field_76773_a[evt.originalMutatedID] != null && BiomeMutationEvent.isValidMutant(originalID, evt.originalMutatedID);
    }

    private static boolean isValidMutant(int originalID, int originalMutatedID) {
        BiomeGenBase child = BiomeGenBase.field_76773_a[originalMutatedID];
        BiomeGenBase parent = BiomeGenBase.field_76773_a[originalID];
        return child instanceof BiomeGenMutated || parent.getClass().isAssignableFrom(child.getClass());
    }

    public static class GetMutatedBiomeEvent
    extends BiomeMutationEvent {
        public int biomeID;

        public GetMutatedBiomeEvent(GenLayer gen, int x, int z, int id) {
            super(gen, x, z, id);
            this.biomeID = this.originalMutatedID;
        }

        public static int fireGet(GenLayer gen, int chunkX, int chunkZ, int x, int z, int originalID) {
            GetMutatedBiomeEvent evt = new GetMutatedBiomeEvent(gen, (chunkX << 4) + x, (chunkZ << 4) + z, originalID);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            return evt.biomeID;
        }
    }
}

