/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Effects;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;

public class LightningBolt {
    public final int nsteps;
    public double variance = 1.0;
    public double velocity = 1.0;
    public final DecimalPosition start;
    public final DecimalPosition end;
    private final DecimalPosition[] middle;
    private final double[][] offsets;
    private final double[][] offsetTargets;

    public LightningBolt(DecimalPosition p1, DecimalPosition p2, int steps) {
        this.nsteps = steps;
        this.start = p1;
        this.end = p2;
        this.offsets = new double[this.nsteps + 1][3];
        this.offsetTargets = new double[this.nsteps + 1][3];
        this.middle = new DecimalPosition[this.nsteps + 1];
        for (int i = 0; i < this.middle.length; ++i) {
            double dx = p1.xCoord + (p2.xCoord - p1.xCoord) * (double)i / (double)this.nsteps;
            double dy = p1.yCoord + (p2.yCoord - p1.yCoord) * (double)i / (double)this.nsteps;
            double dz = p1.zCoord + (p2.zCoord - p1.zCoord) * (double)i / (double)this.nsteps;
            this.middle[i] = new DecimalPosition(dx, dy, dz);
        }
    }

    public void update() {
        for (int i = 1; i < this.nsteps; ++i) {
            double dx = this.offsets[i][0];
            double dy = this.offsets[i][1];
            double dz = this.offsets[i][2];
            double tx = this.offsetTargets[i][0];
            double ty = this.offsetTargets[i][1];
            double tz = this.offsetTargets[i][2];
            if (ReikaMathLibrary.approxr(dx, tx, this.variance / 8.0)) {
                tx = ReikaRandomHelper.getRandomPlusMinus(0.0, this.variance);
            }
            if (ReikaMathLibrary.approxr(dy, ty, this.variance / 8.0)) {
                ty = ReikaRandomHelper.getRandomPlusMinus(0.0, this.variance);
            }
            if (ReikaMathLibrary.approxr(dz, tz, this.variance / 8.0)) {
                tz = ReikaRandomHelper.getRandomPlusMinus(0.0, this.variance);
            }
            if (tx > dx) {
                dx += this.velocity;
            } else if (tx < dx) {
                dx -= this.velocity;
            }
            if (ty > dy) {
                dy += this.velocity;
            } else if (ty < dy) {
                dy -= this.velocity;
            }
            if (tz > dz) {
                dz += this.velocity;
            } else if (tz < dz) {
                dz -= this.velocity;
            }
            this.offsets[i][0] = dx;
            this.offsets[i][1] = dy;
            this.offsets[i][2] = dz;
            this.offsetTargets[i][0] = tx;
            this.offsetTargets[i][1] = ty;
            this.offsetTargets[i][2] = tz;
        }
    }

    public DecimalPosition getPosition(int n) {
        return new DecimalPosition(this.middle[n].xCoord + this.offsets[n][0], this.middle[n].yCoord + this.offsets[n][1], this.middle[n].zCoord + this.offsets[n][2]);
    }
}

