/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.HashMap;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class WeightedRandom<V> {
    private final Random rand = new Random();
    private final HashMap<V, Double> data = new HashMap();
    private double maxWeight = 0.0;
    private double weightSum;

    public double addEntry(V obj, double weight) {
        this.data.put((Double)obj, weight);
        this.weightSum += weight;
        this.maxWeight = Math.max(this.maxWeight, weight);
        return this.weightSum;
    }

    public double remove(V val) {
        double ret = this.data.remove(val);
        this.weightSum -= ret;
        return ret;
    }

    public V getRandomEntry() {
        double d = this.rand.nextDouble() * this.weightSum;
        double p = 0.0;
        for (V obj : this.data.keySet()) {
            if (!(d <= (p += this.data.get(obj).doubleValue()))) continue;
            return obj;
        }
        return null;
    }

    public V getRandomEntry(V fallback, double wt) {
        double sum = this.weightSum + wt;
        double d = this.rand.nextDouble() * sum;
        double p = 0.0;
        for (V obj : this.data.keySet()) {
            if (!(d <= (p += this.data.get(obj).doubleValue()))) continue;
            return obj;
        }
        return fallback;
    }

    public double getWeight(V obj) {
        Double get = this.data.get(obj);
        return get != null ? get : 0.0;
    }

    public double getMaxWeight() {
        return this.maxWeight;
    }

    public double getTotalWeight() {
        return this.weightSum;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int size() {
        return this.data.size();
    }

    public boolean hasEntry(V obj) {
        return this.data.containsKey(obj);
    }

    public String toString() {
        return this.data.toString();
    }

    public void setSeed(long seed) {
        this.rand.setSeed(seed);
    }

    public void clear() {
        this.data.clear();
        this.maxWeight = 0.0;
        this.weightSum = 0.0;
    }

    public static WeightedRandom<Coordinate> fromArray(int[][] arr) {
        WeightedRandom<Coordinate> w = new WeightedRandom<Coordinate>();
        int dx = arr.length / 2;
        for (int i = 0; i < arr.length; ++i) {
            int dz = arr[i].length / 2;
            for (int k = 0; k < arr[i].length; ++k) {
                if (arr[i][k] <= 0) continue;
                Coordinate c = new Coordinate(i - dx, 0, k - dz);
                w.addEntry(c, arr[i][k]);
            }
        }
        return w;
    }

    public static WeightedRandom<Coordinate> fromArray(double[][] arr) {
        WeightedRandom<Coordinate> w = new WeightedRandom<Coordinate>();
        int dx = arr.length / 2;
        for (int i = 0; i < arr.length; ++i) {
            int dz = arr[i].length / 2;
            for (int k = 0; k < arr[i].length; ++k) {
                if (!(arr[i][k] > 0.0)) continue;
                Coordinate c = new Coordinate(i - dx, 0, k - dz);
                w.addEntry(c, arr[i][k]);
            }
        }
        return w;
    }

    public static class InvertedWeightedRandom<V> {
        private final Random rand = new Random();
        private final NavigableMap<Double, V> data = new TreeMap<Double, V>();
        private double weightSum;

        public void addEntry(double weight, V result) {
            this.weightSum += weight;
            this.data.put(this.weightSum, result);
        }

        public V getRandomEntry() {
            double value = this.rand.nextDouble() * this.weightSum;
            return this.data.ceilingEntry(value).getValue();
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public int size() {
            return this.data.size();
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

