/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;

public class SphericalVector {
    public double magnitude;
    public double inclination;
    public double rotation;

    public SphericalVector(double m, double theta, double phi) {
        this.magnitude = m;
        this.inclination = theta;
        this.rotation = phi;
    }

    public static SphericalVector fromCartesian(double dx, double dy, double dz) {
        double[] dat = ReikaPhysicsHelper.cartesianToPolar(dx, dy, dz);
        return new SphericalVector(dat[0], dat[1], dat[2]);
    }

    public double[] getCartesian() {
        return ReikaPhysicsHelper.polarToCartesian(this.magnitude, this.inclination, this.rotation);
    }

    public double getXProjection() {
        return this.getCartesian()[0];
    }

    public double getYProjection() {
        return this.getCartesian()[1];
    }

    public double getZProjection() {
        return this.getCartesian()[2];
    }
}

