/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;

public final class Perimeter {
    private final LinkedList<Coordinate> points = new LinkedList();
    private boolean allowVertical = true;

    public Perimeter disallowVertical() {
        this.allowVertical = false;
        return this;
    }

    public boolean isClosed() {
        return !this.points.isEmpty() && this.points.getFirst().equals(this.points.getLast());
    }

    public boolean hasCoordinate(int x, int y, int z) {
        return this.points.contains(new Coordinate(x, y, z));
    }

    public Collection<Coordinate> getPoints() {
        return Collections.unmodifiableCollection(this.points);
    }

    public boolean addPoint(int x, int y, int z) {
        if (this.isValidNextPoint(x, y, z)) {
            this.points.add(new Coordinate(x, y, z));
            return true;
        }
        return false;
    }

    public Perimeter addPointBeforeLast(int x, int y, int z) {
        if (this.isValidNextPoint(x, y, z)) {
            Coordinate loc = this.points.removeLast();
            this.points.add(new Coordinate(x, y, z));
            this.points.addLast(loc);
        }
        return this;
    }

    private boolean isValidNextPoint(int x, int y, int z) {
        if (this.points.isEmpty()) {
            return true;
        }
        Coordinate loc = this.points.get(this.points.size() - 1);
        int dy = y - loc.yCoord;
        if (dy != 0 && !this.allowVertical) {
            return false;
        }
        int dx = x - loc.xCoord;
        int dz = z - loc.zCoord;
        boolean[] blArray = new boolean[3];
        blArray[0] = dx != 0;
        blArray[1] = dy != 0;
        boolean bl = blArray[2] = dz != 0;
        return ReikaMathLibrary.nBoolsAreTrue(1, blArray);
    }

    public ArrayList<AxisAlignedBB> getAABBs() {
        ArrayList<AxisAlignedBB> li = new ArrayList<AxisAlignedBB>();
        if (this.points.size() < 2) {
            return li;
        }
        for (int i = 1; i < this.points.size(); ++i) {
            Coordinate loc1 = this.points.get(i - 1);
            Coordinate loc2 = this.points.get(i);
            int x1 = loc1.xCoord;
            int y1 = loc1.yCoord;
            int z1 = loc1.zCoord;
            int x2 = loc2.xCoord + 1;
            int y2 = loc2.yCoord + 1;
            int z2 = loc2.zCoord + 1;
            int xmin = Math.min(x1, x2);
            int ymin = Math.min(y1, y2);
            int zmin = Math.min(z1, z2);
            int xmax = Math.max(x1, x2);
            int ymax = Math.max(y1, y2);
            int zmax = Math.max(z1, z2);
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)xmin, (double)ymin, (double)zmin, (double)xmax, (double)ymax, (double)zmax);
            li.add(box);
        }
        return li;
    }

    public void writeToNBT(String name, NBTTagCompound NBT) {
        NBTTagList tag = new NBTTagList();
        for (int i = 0; i < this.points.size(); ++i) {
            Coordinate loc = this.points.get(i);
            NBTTagCompound cpd = loc.writeToTag();
            tag.func_74742_a((NBTBase)cpd);
        }
        NBT.func_74782_a(name, (NBTBase)tag);
    }

    public void readFromNBT(String name, NBTTagCompound NBT) {
        NBTTagList tag = NBT.func_150295_c(name, ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        this.points.clear();
        if (tag != null) {
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound cpd = tag.func_150305_b(i);
                Coordinate loc = Coordinate.readTag(cpd);
                this.points.add(loc);
            }
        }
    }

    public void appendPoint(int x, int y, int z) {
        this.points.add(new Coordinate(x, y, z));
    }

    public void prependPoint(int x, int y, int z) {
        this.points.add(0, new Coordinate(x, y, z));
    }

    public void clear() {
        this.points.clear();
    }

    public String toString() {
        return this.points.toString();
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public Perimeter copy() {
        Perimeter p = new Perimeter();
        p.points.addAll(this.points);
        p.allowVertical = this.allowVertical;
        return p;
    }

    public int segmentCount() {
        return Math.max(0, this.points.size() - 1);
    }

    public Coordinate getSegmentPreCoord(int segment) {
        return this.points.get(segment);
    }

    public Coordinate getSegmentPostCoord(int segment) {
        return this.points.get(segment + 1);
    }
}

