/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PluralMap<V>
extends HashMap {
    public final int keySize;

    public PluralMap(int size) {
        this.keySize = size;
    }

    @Override
    public V put(V value, Object ... key) {
        if (key.length != this.keySize) {
            throw new IllegalArgumentException("Invalid key length!");
        }
        return super.put(this.toList(key), value);
    }

    public V get(Object ... key) {
        if (key.length != this.keySize) {
            throw new IllegalArgumentException("Invalid key length!");
        }
        return super.get(this.toList(key));
    }

    public boolean containsKeyV(Object ... key) {
        if (key.length != this.keySize) {
            throw new IllegalArgumentException("Invalid key length!");
        }
        return super.containsKey(this.toList(key));
    }

    private List<Object> toList(Object[] key) {
        ArrayList<Object> li = new ArrayList<Object>();
        for (int i = 0; i < this.keySize; ++i) {
            li.add(key[i]);
        }
        return li;
    }

    public V remove(Object ... key) {
        if (key.length != this.keySize) {
            throw new IllegalArgumentException("Invalid key length!");
        }
        return super.remove(this.toList(key));
    }

    public Collection<List<Object>> pluralKeySet() {
        return Collections.unmodifiableCollection(this.keySet());
    }
}

