/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import java.util.HashMap;
import java.util.Set;

public class CountMap<V> {
    private final HashMap<V, Integer> data = new HashMap();

    public void increment(V key) {
        this.increment(key, 1);
    }

    public void increment(V key, int num) {
        Integer get = this.data.get(key);
        int has = get != null ? get : 0;
        int next = has + num;
        this.set(key, next);
    }

    public void set(V key, int num) {
        if (num != 0) {
            this.data.put((Integer)key, num);
        } else {
            this.data.remove(key);
        }
    }

    public Integer remove(V key) {
        return this.data.remove(key);
    }

    public int get(V key) {
        Integer get = this.data.get(key);
        return get != null ? get : 0;
    }

    public int size() {
        return this.data.size();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof CountMap && ((CountMap)o).data.equals(this.data);
    }

    public String toString() {
        return this.data.toString();
    }

    public Set<V> keySet() {
        return this.data.keySet();
    }

    public boolean containsKey(V key) {
        return this.data.containsKey(key);
    }

    public void clear() {
        this.data.clear();
    }

    public WeightedRandom<V> asWeightedRandom() {
        WeightedRandom<V> w = new WeightedRandom<V>();
        for (V key : this.data.keySet()) {
            w.addEntry(key, this.get(key));
        }
        return w;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }
}

