/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.lang.ref.WeakReference;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldLocation {
    private static final Random rand = new Random();
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    public final int dimensionID;
    private boolean isRemote = false;
    private WeakReference<World> clientWorld;

    public WorldLocation(World world, int x, int y, int z) {
        this(world.field_73011_w.field_76574_g, x, y, z);
        if (world.field_72995_K) {
            this.isRemote = true;
            this.clientWorld = new WeakReference<World>(world);
        }
    }

    public WorldLocation(int dim, int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionID = dim;
    }

    private WorldLocation(WorldLocation loc) {
        this(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public WorldLocation(TileEntity te) {
        this(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public WorldLocation(Entity e) {
        this(e.field_70170_p, MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v));
    }

    public WorldLocation(World world, Coordinate loc) {
        this(world, loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public WorldLocation(World world, MovingObjectPosition hit) {
        this(world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
    }

    public Block getBlock() {
        World world = this.getWorld();
        return world != null ? world.func_147439_a(this.xCoord, this.yCoord, this.zCoord) : null;
    }

    public boolean isEmpty() {
        return this.getBlock() == Blocks.field_150350_a;
    }

    public int getBlockMetadata() {
        World world = this.getWorld();
        return world != null ? world.func_72805_g(this.xCoord, this.yCoord, this.zCoord) : -1;
    }

    public TileEntity getTileEntity() {
        World world = this.getWorld();
        return world != null ? world.func_147438_o(this.xCoord, this.yCoord, this.zCoord) : null;
    }

    public int getRedstone() {
        World world = this.getWorld();
        return world != null ? world.func_94577_B(this.xCoord, this.yCoord, this.zCoord) : 0;
    }

    public int getRedstoneOnSide(ForgeDirection dir) {
        ForgeDirection opp = dir.getOpposite();
        int s = dir.ordinal();
        World world = this.getWorld();
        return world != null ? world.func_72878_l(this.xCoord + opp.offsetX, this.yCoord + opp.offsetY, this.zCoord + opp.offsetZ, s) : 0;
    }

    public boolean isRedstonePowered() {
        World world = this.getWorld();
        return world != null ? world.func_72864_z(this.xCoord, this.yCoord, this.zCoord) : false;
    }

    public void triggerBlockUpdate(boolean adjacent) {
        World world = this.getWorld();
        if (world != null) {
            world.func_147471_g(this.xCoord, this.yCoord, this.zCoord);
            if (adjacent) {
                ReikaWorldHelper.causeAdjacentUpdates(world, this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public void dropItem(ItemStack is) {
        this.dropItem(is, 1.0);
    }

    public void dropItem(ItemStack is, double vscale) {
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            ReikaItemHelper.dropItem(this.getWorld(), (double)this.xCoord + rand.nextDouble(), (double)this.yCoord + rand.nextDouble(), (double)this.zCoord + rand.nextDouble(), is, vscale);
        }
    }

    public void setBlock(Block b) {
        this.setBlock(b, 0);
    }

    public void setBlock(ItemStack is) {
        this.setBlock(Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j());
    }

    public void setBlock(Block id, int meta) {
        World world = this.getWorld();
        if (world != null) {
            world.func_147465_d(this.xCoord, this.yCoord, this.zCoord, id, meta, 3);
        }
    }

    public WorldLocation move(int dx, int dy, int dz) {
        return new WorldLocation(this.dimensionID, this.xCoord + dx, this.yCoord + dy, this.zCoord + dz);
    }

    public WorldLocation move(ForgeDirection dir, int dist) {
        return this.move(dir.offsetX * dist, dir.offsetY * dist, dir.offsetZ * dist);
    }

    public WorldLocation changeWorld(World world) {
        return new WorldLocation(world, this.xCoord, this.yCoord, this.zCoord);
    }

    public World getWorld() {
        return this.isRemote && this.clientWorld.get() != null ? (World)this.clientWorld.get() : DimensionManager.getWorld((int)this.dimensionID);
    }

    public void writeToNBT(String tag, NBTTagCompound NBT) {
        NBTTagCompound data = new NBTTagCompound();
        this.writeToNBT(data);
        NBT.func_74782_a(tag, (NBTBase)data);
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("dim", this.dimensionID);
        data.func_74768_a("x", this.xCoord);
        data.func_74768_a("y", this.yCoord);
        data.func_74768_a("z", this.zCoord);
    }

    public static final WorldLocation readFromNBT(NBTTagCompound data) {
        int x = data.func_74762_e("x");
        int y = data.func_74762_e("y");
        int z = data.func_74762_e("z");
        int dim = data.func_74762_e("dim");
        return new WorldLocation(dim, x, y, z);
    }

    public static final WorldLocation readFromNBT(String tag, NBTTagCompound NBT) {
        if (!NBT.func_74764_b(tag)) {
            return null;
        }
        NBTTagCompound data = NBT.func_74775_l(tag);
        if (data != null) {
            return WorldLocation.readFromNBT(data);
        }
        return null;
    }

    public NBTTagCompound writeToTag() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("dim", this.dimensionID);
        data.func_74768_a("x", this.xCoord);
        data.func_74768_a("y", this.yCoord);
        data.func_74768_a("z", this.zCoord);
        return data;
    }

    public static final WorldLocation readTag(NBTTagCompound data) {
        int x = data.func_74762_e("x");
        int y = data.func_74762_e("y");
        int z = data.func_74762_e("z");
        int dim = data.func_74762_e("dim");
        return new WorldLocation(dim, x, y, z);
    }

    public WorldLocation copy() {
        return new WorldLocation(this);
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord + " in DIM" + this.dimensionID;
    }

    public int hashCode() {
        return this.xCoord + (this.zCoord << 8) + (this.yCoord << 16) + (this.dimensionID << 24);
    }

    public boolean equals(Object o) {
        if (o instanceof WorldLocation) {
            WorldLocation w = (WorldLocation)o;
            return this.equals(w.dimensionID, w.xCoord, w.yCoord, w.zCoord);
        }
        return false;
    }

    private boolean equals(int dim, int x, int y, int z) {
        return dim == this.dimensionID && x == this.xCoord && y == this.yCoord && z == this.zCoord;
    }

    public boolean equals(World world, int x, int y, int z) {
        return this.equals(world.field_73011_w.field_76574_g, x, y, z);
    }

    public double getDistanceTo(WorldLocation src) {
        return this.getDistanceTo(src.xCoord, src.yCoord, src.zCoord);
    }

    public double getDistanceTo(double x, double y, double z) {
        return ReikaMathLibrary.py3d(x - (double)this.xCoord, y - (double)this.yCoord, z - (double)this.zCoord);
    }

    public double getDistanceTo(Entity e) {
        return this.getDistanceTo(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public double getSquareDistanceTo(double x, double y, double z) {
        return Math.abs(x - (double)this.xCoord) + Math.abs(y - (double)this.yCoord) + Math.abs(z - (double)this.zCoord);
    }

    public boolean isWithinSquare(WorldLocation c, int d) {
        return this.isWithinSquare(c, d, d, d);
    }

    public boolean isWithinSquare(WorldLocation c, int dx, int dy, int dz) {
        return c.dimensionID == this.dimensionID && Math.abs(c.xCoord - this.xCoord) <= dx && Math.abs(c.yCoord - this.yCoord) <= dy && Math.abs(c.zCoord - this.zCoord) <= dz;
    }

    public DoubleWorldLocation decimalOffset(double dx, double dy, double dz) {
        return new DoubleWorldLocation(this, dx, dy, dz);
    }

    public String toSerialString() {
        return String.format("%d:%d:%d:%d", this.dimensionID, this.xCoord, this.yCoord, this.zCoord);
    }

    public static WorldLocation fromSerialString(String s) {
        String[] parts = s.split(":");
        return new WorldLocation(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
    }

    public ChunkCoordIntPair getChunk() {
        return new ChunkCoordIntPair(this.xCoord >> 4, this.zCoord >> 4);
    }

    public BlockKey getBlockKey() {
        return new BlockKey(this.getBlock(), this.getBlockMetadata());
    }

    public boolean isWithinDistOnAllCoords(WorldLocation loc, int radius) {
        return Math.abs(loc.xCoord - this.xCoord) <= radius && Math.abs(loc.yCoord - this.yCoord) <= radius && Math.abs(loc.zCoord - this.zCoord) <= radius;
    }

    public boolean canSeeTheSky() {
        return this.getWorld().func_72937_j(this.xCoord, this.yCoord + 1, this.zCoord);
    }

    public static final class DoubleWorldLocation
    extends WorldLocation {
        public final double offsetX;
        public final double offsetY;
        public final double offsetZ;

        private DoubleWorldLocation(WorldLocation loc, double dx, double dy, double dz) {
            super(loc);
            this.offsetX = dx;
            this.offsetY = dy;
            this.offsetZ = dz;
        }
    }
}

