/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraftforge.common.util.ForgeDirection;

public final class LineSegment {
    public final int originX;
    public final int originY;
    public final int originZ;
    public final ForgeDirection direction;
    public final int length;

    public LineSegment(int x, int y, int z, ForgeDirection dir, int len) {
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.direction = dir;
        this.length = len;
    }

    public static final LineSegment getFromDXYZ(int x1, int x2, int y1, int y2, int z1, int z2) {
        ForgeDirection dir = ReikaDirectionHelper.getDirectionBetween(x1, y1, z1, x2, y2, z2);
        if (dir == null) {
            DragonAPICore.logError("Invalid coordinates!");
            return null;
        }
        int len = Math.abs(x2 - x1 + y2 - y1 + z2 - z1);
        return new LineSegment(x1, y1, z1, dir, len);
    }

    public String toString() {
        return String.format("%d, %d, %d >> %d %s", this.originX, this.originY, this.originZ, this.length, this.direction.toString());
    }

    public boolean equals(Object o) {
        if (o instanceof LineSegment) {
            LineSegment ls = (LineSegment)o;
            return this.matchOrigin(ls) && ls.direction == this.direction && ls.length == this.length;
        }
        return false;
    }

    public boolean matchOrigin(LineSegment ls) {
        return ls.originX == this.originX && ls.originY == this.originY && ls.originZ == this.originZ;
    }

    public int hashCode() {
        return this.originX + this.originY + this.originZ + (this.direction.ordinal() << 24) + (this.length << 16);
    }
}

