/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class DecimalPosition {
    private static final Random rand = new Random();
    public final double xCoord;
    public final double yCoord;
    public final double zCoord;

    public DecimalPosition(double x, double y, double z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public DecimalPosition(TileEntity te) {
        this((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5);
    }

    public DecimalPosition(Coordinate c) {
        this((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
    }

    public DecimalPosition(Entity e) {
        this(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public DecimalPosition(DecimalPosition loc) {
        this(loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public DecimalPosition(MovingObjectPosition hit) {
        this((double)hit.field_72311_b + 0.5, (double)hit.field_72312_c + 0.5, (double)hit.field_72309_d + 0.5);
    }

    public DecimalPosition(WorldLocation src) {
        this((double)src.xCoord + 0.5, (double)src.yCoord + 0.5, (double)src.zCoord + 0.5);
    }

    public DecimalPosition offset(double dx, double dy, double dz) {
        return new DecimalPosition(this.xCoord + dx, this.yCoord + dy, this.zCoord + dz);
    }

    public DecimalPosition offset(ForgeDirection dir, double dist) {
        return this.offset((double)dir.offsetX * dist, (double)dir.offsetY * dist, (double)dir.offsetZ * dist);
    }

    public boolean sharesBlock(DecimalPosition dec) {
        return this.sharesBlock(dec.xCoord, dec.yCoord, dec.zCoord);
    }

    public boolean sharesBlock(double x, double y, double z) {
        return this.matchX(x) && this.matchY(y) && this.matchZ(z);
    }

    private boolean matchX(double x) {
        return MathHelper.func_76128_c((double)x) == MathHelper.func_76128_c((double)this.xCoord);
    }

    private boolean matchY(double y) {
        return MathHelper.func_76128_c((double)y) == MathHelper.func_76128_c((double)this.yCoord);
    }

    private boolean matchZ(double z) {
        return MathHelper.func_76128_c((double)z) == MathHelper.func_76128_c((double)this.zCoord);
    }

    public void writeToNBT(String tag, NBTTagCompound NBT) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("x", this.xCoord);
        data.func_74780_a("y", this.yCoord);
        data.func_74780_a("z", this.zCoord);
        NBT.func_74782_a(tag, (NBTBase)data);
    }

    public static final DecimalPosition readFromNBT(String tag, NBTTagCompound NBT) {
        if (!NBT.func_74764_b(tag)) {
            return null;
        }
        NBTTagCompound data = NBT.func_74775_l(tag);
        if (data != null) {
            double x = data.func_74769_h("x");
            double y = data.func_74769_h("y");
            double z = data.func_74769_h("z");
            return new DecimalPosition(x, y, z);
        }
        return null;
    }

    public NBTTagCompound writeToTag() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("x", this.xCoord);
        data.func_74780_a("y", this.yCoord);
        data.func_74780_a("z", this.zCoord);
        return data;
    }

    public static final DecimalPosition readTag(NBTTagCompound data) {
        double x = data.func_74769_h("x");
        double y = data.func_74769_h("y");
        double z = data.func_74769_h("z");
        return new DecimalPosition(x, y, z);
    }

    public DecimalPosition copy() {
        return new DecimalPosition(this.xCoord, this.yCoord, this.zCoord);
    }

    public String toString() {
        return "[" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + "]";
    }

    public int hashCode() {
        return (int)(this.xCoord + this.zCoord * 256.0 + this.yCoord * 65536.0);
    }

    public boolean equals(Object o) {
        if (o instanceof DecimalPosition) {
            DecimalPosition w = (DecimalPosition)o;
            return this.equals(w.xCoord, w.yCoord, w.zCoord);
        }
        return false;
    }

    private boolean equals(double x, double y, double z) {
        return x == this.xCoord && y == this.yCoord && z == this.zCoord;
    }

    public double getDistanceTo(DecimalPosition src) {
        return this.getDistanceTo(src.xCoord, src.yCoord, src.zCoord);
    }

    public double getDistanceTo(double x, double y, double z) {
        return ReikaMathLibrary.py3d(x - this.xCoord, y - this.yCoord, z - this.zCoord);
    }

    public boolean isWithinSquare(Coordinate c, double d) {
        return this.isWithinSquare(c, d, d, d);
    }

    public boolean isWithinSquare(Coordinate c, double dx, double dy, double dz) {
        return Math.abs((double)c.xCoord - this.xCoord) <= dx && Math.abs((double)c.yCoord - this.yCoord) <= dy && Math.abs((double)c.zCoord - this.zCoord) <= dz;
    }

    public double[] toArray() {
        double[] a = new double[]{this.xCoord, this.yCoord, this.zCoord};
        return a;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(MathHelper.func_76128_c((double)this.xCoord), MathHelper.func_76128_c((double)this.yCoord), MathHelper.func_76128_c((double)this.zCoord));
    }

    public Block getBlock(World world) {
        return world != null ? this.getCoordinate().getBlock(world) : null;
    }

    public boolean isEmpty(World world) {
        return this.getBlock(world) == Blocks.field_150350_a;
    }

    public int getBlockMetadata(World world) {
        return world != null ? this.getCoordinate().getBlockMetadata(world) : -1;
    }

    public TileEntity getTileEntity(World world) {
        return world != null ? this.getCoordinate().getTileEntity(world) : null;
    }

    public int getRedstone(World world) {
        return world != null ? this.getCoordinate().getRedstone(world) : 0;
    }

    public void triggerBlockUpdate(World world, boolean adjacent) {
        this.getCoordinate().triggerBlockUpdate(world, adjacent);
    }

    public void dropItem(World world, ItemStack is) {
        this.dropItem(world, is, 1.0);
    }

    public void dropItem(World world, ItemStack is, double vscale) {
        if (world != null && !world.field_72995_K) {
            ReikaItemHelper.dropItem(world, this.xCoord + rand.nextDouble(), this.yCoord + rand.nextDouble(), this.zCoord + rand.nextDouble(), is, vscale);
        }
    }

    public boolean setBlock(World world, Block b) {
        return this.setBlock(world, b, 0);
    }

    public boolean setBlock(World world, ItemStack is) {
        return this.setBlock(world, Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j());
    }

    public boolean setBlock(World world, Block id, int meta) {
        return world != null && this.getCoordinate().setBlock(world, id, meta);
    }

    public DecimalPosition negate() {
        return new DecimalPosition(this.xCoord, this.yCoord, this.zCoord);
    }

    public static DecimalPosition interpolate(DecimalPosition p1, DecimalPosition p2, double f) {
        return new DecimalPosition(p1.xCoord + (p2.xCoord - p1.xCoord) * f, p1.yCoord + (p2.yCoord - p1.yCoord) * f, p1.zCoord + (p2.zCoord - p1.zCoord) * f);
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeDouble(this.xCoord);
        buf.writeDouble(this.yCoord);
        buf.writeDouble(this.zCoord);
    }

    public static DecimalPosition readFromBuf(ByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new DecimalPosition(x, y, z);
    }

    public String formattedString(int decimal) {
        String part = "%." + decimal + "f";
        return String.format(part + ", " + part + ", " + part, this.xCoord, this.yCoord, this.zCoord);
    }
}

