/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public final class CoordinateData {
    public final Block block;
    public final int meta;
    public final TileEntity tile;

    public CoordinateData(WorldLocation loc) {
        this(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public CoordinateData(World world, int x, int y, int z) {
        this(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), world.func_147438_o(x, y, z));
    }

    public CoordinateData(World world, MovingObjectPosition hit) {
        this(world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
    }

    private CoordinateData(Block b, int meta, TileEntity te) {
        this.block = b;
        this.meta = meta;
        this.tile = te;
    }

    public int hashCode() {
        return this.block.hashCode() + (this.meta << 24) + (this.tile != null ? this.tile.hashCode() : 0);
    }

    public boolean equals(Object o) {
        if (o instanceof CoordinateData) {
            CoordinateData cd = (CoordinateData)o;
            return cd.block == this.block && cd.meta == this.meta && CoordinateData.matchTiles(this.tile, cd.tile);
        }
        return false;
    }

    private static boolean matchTiles(TileEntity t1, TileEntity t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.equals(t2);
    }
}

