/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public final class Coordinate {
    private static final Random rand = new Random();
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;

    public Coordinate(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public Coordinate(double x, double y, double z) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public Coordinate(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public Coordinate(Entity e) {
        this(MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v));
    }

    public Coordinate(WorldLocation loc) {
        this(loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public Coordinate(MovingObjectPosition hit) {
        this(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
    }

    public Coordinate(ChunkCoordinates cc) {
        this(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
    }

    public Coordinate offset(int dx, int dy, int dz) {
        return new Coordinate(this.xCoord + dx, this.yCoord + dy, this.zCoord + dz);
    }

    public Coordinate offset(ForgeDirection dir, int dist) {
        return this.offset(dir.offsetX * dist, dir.offsetY * dist, dir.offsetZ * dist);
    }

    public Coordinate offset(Coordinate c) {
        return this.offset(c.xCoord, c.yCoord, c.zCoord);
    }

    public void writeToNBT(String tag, NBTTagCompound NBT) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("x", this.xCoord);
        data.func_74768_a("y", this.yCoord);
        data.func_74768_a("z", this.zCoord);
        NBT.func_74782_a(tag, (NBTBase)data);
    }

    public static final Coordinate readFromNBT(String tag, NBTTagCompound NBT) {
        if (!NBT.func_74764_b(tag)) {
            return null;
        }
        NBTTagCompound data = NBT.func_74775_l(tag);
        if (data != null) {
            int x = data.func_74762_e("x");
            int y = data.func_74762_e("y");
            int z = data.func_74762_e("z");
            return new Coordinate(x, y, z);
        }
        return null;
    }

    public void writeToTag(NBTTagCompound data) {
        data.func_74768_a("x", this.xCoord);
        data.func_74768_a("y", this.yCoord);
        data.func_74768_a("z", this.zCoord);
    }

    public NBTTagCompound writeToTag() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("x", this.xCoord);
        data.func_74768_a("y", this.yCoord);
        data.func_74768_a("z", this.zCoord);
        return data;
    }

    public static final Coordinate readTag(NBTTagCompound data) {
        int x = data.func_74762_e("x");
        int y = data.func_74762_e("y");
        int z = data.func_74762_e("z");
        return new Coordinate(x, y, z);
    }

    public Coordinate copy() {
        return new Coordinate(this.xCoord, this.yCoord, this.zCoord);
    }

    public String toString() {
        return "[" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + "]";
    }

    public int hashCode() {
        return this.xCoord + (this.zCoord << 8) + (this.yCoord << 16);
    }

    public boolean equals(Object o) {
        if (o instanceof Coordinate) {
            Coordinate w = (Coordinate)o;
            return this.equals(w.xCoord, w.yCoord, w.zCoord);
        }
        return false;
    }

    public boolean equals(int x, int y, int z) {
        return x == this.xCoord && y == this.yCoord && z == this.zCoord;
    }

    public double getDistanceTo(Coordinate src) {
        return this.getDistanceTo(src.xCoord, src.yCoord, src.zCoord);
    }

    public double getDistanceTo(double x, double y, double z) {
        return ReikaMathLibrary.py3d(x - (double)this.xCoord, y - (double)this.yCoord, z - (double)this.zCoord);
    }

    public double getDistanceTo(Entity e) {
        return this.getDistanceTo(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public boolean isWithinSquare(Coordinate c, int d) {
        return this.isWithinSquare(c, d, d, d);
    }

    public boolean isWithinSquare(Coordinate c, int dx, int dy, int dz) {
        return Math.abs(c.xCoord - this.xCoord) <= dx && Math.abs(c.yCoord - this.yCoord) <= dy && Math.abs(c.zCoord - this.zCoord) <= dz;
    }

    public int getTaxicabDistanceTo(Coordinate c) {
        return Math.abs(c.xCoord - this.xCoord) + Math.abs(c.yCoord - this.yCoord) + Math.abs(c.zCoord - this.zCoord);
    }

    public int[] toArray() {
        int[] a = new int[]{this.xCoord, this.yCoord, this.zCoord};
        return a;
    }

    public Block getBlock(World world) {
        return world != null ? world.func_147439_a(this.xCoord, this.yCoord, this.zCoord) : null;
    }

    public boolean isEmpty(World world) {
        return this.getBlock(world).isAir((IBlockAccess)world, this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean softBlock(World world) {
        return ReikaWorldHelper.softBlocks((IBlockAccess)world, this.xCoord, this.yCoord, this.zCoord);
    }

    public int getBlockMetadata(World world) {
        return world != null ? world.func_72805_g(this.xCoord, this.yCoord, this.zCoord) : -1;
    }

    public BlockKey getBlockKey(World world) {
        return world != null ? new BlockKey(world.func_147439_a(this.xCoord, this.yCoord, this.zCoord), world.func_72805_g(this.xCoord, this.yCoord, this.zCoord)) : null;
    }

    public TileEntity getTileEntity(World world) {
        return world != null ? world.func_147438_o(this.xCoord, this.yCoord, this.zCoord) : null;
    }

    public int getRedstone(World world) {
        return world != null ? world.func_94577_B(this.xCoord, this.yCoord, this.zCoord) : 0;
    }

    public void triggerBlockUpdate(World world, boolean adjacent) {
        if (world != null) {
            world.func_147471_g(this.xCoord, this.yCoord, this.zCoord);
            if (adjacent) {
                ReikaWorldHelper.causeAdjacentUpdates(world, this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public void dropItem(World world, ItemStack is) {
        this.dropItem(world, is, 1.0);
    }

    public void dropItem(World world, ItemStack is, double vscale) {
        if (world != null && !world.field_72995_K) {
            ReikaItemHelper.dropItem(world, (double)this.xCoord + rand.nextDouble(), (double)this.yCoord + rand.nextDouble(), (double)this.zCoord + rand.nextDouble(), is, vscale);
        }
    }

    public boolean setBlock(World world, Block b) {
        return this.setBlock(world, b, 0);
    }

    public boolean setBlock(World world, ItemStack is) {
        return this.setBlock(world, Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j());
    }

    public boolean setBlock(World world, Block id, int meta) {
        return this.setBlock(world, id, meta, 3);
    }

    public boolean setBlockMetadata(World world, int meta) {
        return world.func_72921_c(this.xCoord, this.yCoord, this.zCoord, meta, 3);
    }

    public boolean setBlock(World world, Block id, int meta, int flags) {
        return world != null && world.func_147465_d(this.xCoord, this.yCoord, this.zCoord, id, meta, flags);
    }

    public BiomeGenBase getBiome(World world) {
        return world.func_72807_a(this.xCoord, this.zCoord);
    }

    public void updateTick(World world) {
        this.updateTick(world, world.field_73012_v);
    }

    public void updateTick(World world, Random r) {
        Block b = this.getBlock(world);
        b.func_149674_a(world, this.xCoord, this.yCoord, this.zCoord, r);
        BlockTickEvent.fire(world, this.xCoord, this.yCoord, this.zCoord, b, BlockTickEvent.UpdateFlags.FORCED.flag);
    }

    public void scheduleUpdateTick(World world, int delay) {
        world.func_147464_a(this.xCoord, this.yCoord, this.zCoord, this.getBlock(world), delay);
    }

    public ChunkCoordIntPair asChunkPair() {
        return new ChunkCoordIntPair(this.xCoord >> 4, this.zCoord >> 4);
    }

    public List<Integer> asIntList() {
        return Arrays.asList(this.xCoord, this.yCoord, this.zCoord);
    }

    public Coordinate negate() {
        return new Coordinate(-this.xCoord, -this.yCoord, -this.zCoord);
    }

    public Coordinate rotate90About(int ox, int oz, boolean left) {
        int dx = this.xCoord - ox;
        int dz = this.zCoord - oz;
        int x2 = this.xCoord;
        int z2 = this.zCoord;
        if (left) {
            x2 += dz;
            z2 += -dx;
        } else {
            x2 += -dz;
            z2 += dx;
        }
        return new Coordinate(x2, this.yCoord, z2);
    }

    public Coordinate rotate180About(int ox, int oz) {
        int dx = this.xCoord - ox;
        int dz = this.zCoord - oz;
        int x2 = ox - dx;
        int z2 = oz - dz;
        return new Coordinate(x2, this.yCoord, z2);
    }

    public void writeToBuf(ByteBuf data) {
        data.writeInt(this.xCoord);
        data.writeInt(this.yCoord);
        data.writeInt(this.zCoord);
    }

    public static Coordinate readFromBuf(ByteBuf data) {
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        return new Coordinate(x, y, z);
    }

    public Coordinate getDifference(Coordinate c) {
        return this.offset(c.negate());
    }

    public void destroyBlockPartially(World world, double i) {
        world.func_147443_d(Block.func_149682_b((Block)this.getBlock(world)), this.xCoord, this.yCoord, this.zCoord, (int)i);
    }

    public ChunkCoordinates asChunkCoordinates() {
        return new ChunkCoordinates(this.xCoord, this.yCoord, this.zCoord);
    }
}

