/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public final class BlockBox {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public BlockBox(int min, int max) {
        this(min, min, min, max, max, max);
    }

    public BlockBox(int x0, int y0, int z0, int x1, int y1, int z1) {
        this.minX = Math.min(x0, x1);
        this.minY = Math.min(y0, y1);
        this.minZ = Math.min(z0, z1);
        this.maxX = Math.max(x0, x1);
        this.maxY = Math.max(y0, y1);
        this.maxZ = Math.max(z0, z1);
    }

    public BlockBox(WorldLocation loc, WorldLocation loc2) {
        this(loc.xCoord, loc.yCoord, loc.zCoord, loc2.xCoord, loc2.yCoord, loc2.zCoord);
    }

    public static BlockBox infinity() {
        return new BlockBox(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static BlockBox nothing() {
        return new BlockBox(Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public int getSizeX() {
        return this.maxX - this.minX + 1;
    }

    public int getSizeY() {
        return this.maxY - this.minY + 1;
    }

    public int getSizeZ() {
        return this.maxZ - this.minZ + 1;
    }

    public int getVolume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    public BlockBox expand(int amt) {
        return this.expand(amt, amt, amt);
    }

    public BlockBox expand(int dx, int dy, int dz) {
        return new BlockBox(this.minX - dx, this.minY - dy, this.minZ - dz, this.maxX + dx, this.maxY + dy, this.maxZ + dz);
    }

    public BlockBox shift(ForgeDirection dir, int dist) {
        return this.shift(dist * dir.offsetX, dist * dir.offsetY, dist * dir.offsetZ);
    }

    public BlockBox shift(int dx, int dy, int dz) {
        return new BlockBox(this.minX + dx, this.minY + dy, this.minZ + dz, this.maxX + dx, this.maxY + dy, this.maxZ + dz);
    }

    public BlockBox clamp(ForgeDirection side, int value) {
        int minx = this.minX;
        int miny = this.minY;
        int minz = this.minZ;
        int maxx = this.maxX;
        int maxy = this.maxY;
        int maxz = this.maxX;
        switch (side) {
            case DOWN: {
                miny = Math.max(value, miny);
                break;
            }
            case UP: {
                maxy = Math.min(value, maxy);
                break;
            }
            case EAST: {
                maxx = Math.min(value, maxx);
                break;
            }
            case WEST: {
                minx = Math.max(value, minx);
                break;
            }
            case NORTH: {
                minz = Math.max(value, minz);
                break;
            }
            case SOUTH: {
                maxz = Math.min(value, maxz);
                break;
            }
        }
        return new BlockBox(minx, miny, minz, maxx, maxy, maxz);
    }

    public boolean isBlockInside(int x, int y, int z) {
        boolean ix = ReikaMathLibrary.isValueInsideBoundsIncl(this.minX, this.maxX, x);
        boolean iy = ReikaMathLibrary.isValueInsideBoundsIncl(this.minY, this.maxY, y);
        boolean iz = ReikaMathLibrary.isValueInsideBoundsIncl(this.minZ, this.maxZ, z);
        return ix && iy && iz;
    }

    public boolean equals(Object o) {
        if (o instanceof BlockBox) {
            BlockBox b = (BlockBox)o;
            return b.maxX == this.maxX && b.maxY == this.maxY && b.maxZ == this.maxZ && b.minX == this.minX && b.minY == this.minY && b.minZ == this.minZ;
        }
        return false;
    }

    public int hashCode() {
        return this.minX + this.maxX + this.minY + this.maxY + this.minZ + this.maxZ;
    }

    public String toString() {
        return String.format("%d, %d, %d >> %d, %d, %d", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public AxisAlignedBB asAABB() {
        return AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
    }

    public static BlockBox readFromNBT(NBTTagCompound tag) {
        int minx = tag.func_74762_e("minx");
        int miny = tag.func_74762_e("miny");
        int minz = tag.func_74762_e("minz");
        int maxx = tag.func_74762_e("maxx");
        int maxy = tag.func_74762_e("maxy");
        int maxz = tag.func_74762_e("maxz");
        return new BlockBox(minx, miny, minz, maxx, maxy, maxz);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("minx", this.minX);
        tag.func_74768_a("miny", this.minY);
        tag.func_74768_a("minz", this.minZ);
        tag.func_74768_a("maxx", this.maxX);
        tag.func_74768_a("maxy", this.maxY);
        tag.func_74768_a("maxz", this.maxZ);
    }

    public BlockBox offset(Coordinate offset) {
        return new BlockBox(this.minX + offset.xCoord, this.minY + offset.yCoord, this.minZ + offset.zCoord, this.maxX + offset.xCoord, this.maxY + offset.yCoord, this.maxZ + offset.zCoord);
    }
}

