/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Collections;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import net.minecraft.util.Vec3;

public class RelativePositionList {
    private final BlockArray positions = new BlockArray();
    public static final RelativePositionList cornerDirections = new RelativePositionList();

    public void addPosition(int dx, int dy, int dz) {
        this.positions.addBlockCoordinate(dx, dy, dz);
    }

    public void removePosition(int dx, int dy, int dz) {
        this.positions.remove(dx, dy, dz);
    }

    public boolean containsPosition(int dx, int dy, int dz) {
        return this.positions.hasBlock(dx, dy, dz);
    }

    public BlockArray getPositionsRelativeTo(int x, int y, int z) {
        return this.positions.copy().offset(x, y, z);
    }

    public int getSize() {
        return this.positions.getSize();
    }

    public Coordinate getNthPosition(int x, int y, int z, int n) {
        Coordinate relative = this.getNthRelativePosition(n);
        return relative.offset(x, y, z);
    }

    public Coordinate getNthRelativePosition(int n) {
        return this.positions.getNthBlock(n);
    }

    public Vec3 getVector(int n) {
        Coordinate d = this.getNthRelativePosition(n);
        return Vec3.func_72443_a((double)d.xCoord, (double)d.yCoord, (double)d.zCoord);
    }

    static {
        cornerDirections.addPosition(-1, -1, -1);
        cornerDirections.addPosition(-1, -1, 0);
        cornerDirections.addPosition(-1, -1, 1);
        cornerDirections.addPosition(-1, 0, -1);
        cornerDirections.addPosition(-1, 0, 1);
        cornerDirections.addPosition(-1, 1, -1);
        cornerDirections.addPosition(-1, 1, 0);
        cornerDirections.addPosition(-1, 1, 1);
        cornerDirections.addPosition(0, -1, -1);
        cornerDirections.addPosition(0, -1, 1);
        cornerDirections.addPosition(0, 1, -1);
        cornerDirections.addPosition(0, 1, 1);
        cornerDirections.addPosition(1, -1, -1);
        cornerDirections.addPosition(1, -1, 0);
        cornerDirections.addPosition(1, -1, 1);
        cornerDirections.addPosition(1, 0, -1);
        cornerDirections.addPosition(1, 0, 1);
        cornerDirections.addPosition(1, 1, -1);
        cornerDirections.addPosition(1, 1, 0);
        cornerDirections.addPosition(1, 1, 1);
    }
}

