/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Collections;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.InventorySlot;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class ItemCollection {
    private final ItemHashMap<Collection<InventorySlot>> data = new ItemHashMap();
    private final Collection<IInventory> inventories = new HashSet<IInventory>();
    private final ItemHashMap<Collection<IDeepStorageUnit>> dsus = new ItemHashMap();

    public ItemCollection addInventory(IInventory ii) {
        if (InterfaceCache.DSU.instanceOf(ii)) {
            this.addDSU((IDeepStorageUnit)ii);
        } else {
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                this.addSlot(new InventorySlot(i, ii));
            }
        }
        this.inventories.add(ii);
        return this;
    }

    @DependentMethodStripper.ClassDependent(value="powercrystals.minefactoryreloaded.api.IDeepStorageUnit")
    private void addDSU(IDeepStorageUnit dsu) {
        ItemStack is = dsu.getStoredItemType();
        if (is != null) {
            Collection<IDeepStorageUnit> c = this.dsus.get(is);
            if (c == null) {
                c = new ArrayList<IDeepStorageUnit>();
                this.dsus.put(is, c);
            }
            c.add(dsu);
        }
    }

    public ItemCollection addSlot(InventorySlot slot) {
        ItemStack is = slot.getStack();
        if (is != null) {
            this.addItemToData(is, slot);
        }
        this.inventories.add(slot.inventory);
        return this;
    }

    private void addItemToData(ItemStack is, InventorySlot slot) {
        int has = this.getItemCount(is);
        Collection<InventorySlot> li = this.data.get(is);
        if (li == null) {
            li = new ArrayList<InventorySlot>();
            this.data.put(is, li);
        }
        li.add(slot);
    }

    public boolean hasItem(ItemStack is) {
        return this.data.containsKey(is) || this.dsus.containsKey(is);
    }

    public int addItemsToUnderlyingInventories(ItemStack is, boolean simulate) {
        int left = is.field_77994_a;
        for (IInventory ii : this.inventories) {
            left = ReikaInventoryHelper.addToInventoryWithLeftover(is, ii, simulate);
            if (!simulate) {
                is.field_77994_a = left;
            }
            if (left > 0) continue;
            return 0;
        }
        return left;
    }

    public int getItemCount(ItemStack is) {
        Collection<IDeepStorageUnit> li2;
        int count = 0;
        Collection<InventorySlot> li = this.data.get(is);
        if (li != null) {
            for (InventorySlot slot : li) {
                if (is.field_77990_d != null && !is.field_77990_d.equals((Object)slot.getStack().field_77990_d)) continue;
                count += slot.getStackSize();
            }
        }
        if ((li2 = this.dsus.get(is)) != null) {
            for (IDeepStorageUnit dsu : li2) {
                if (is.field_77990_d != null && !is.field_77990_d.equals((Object)dsu.getStoredItemType().field_77990_d)) continue;
                count += dsu.getStoredItemType().field_77994_a;
            }
        }
        return count;
    }

    public int removeXItems(ItemStack is, int amt) {
        Collection<IDeepStorageUnit> li2;
        Collection<InventorySlot> li = this.data.get(is);
        int rem = 0;
        if (li != null) {
            Iterator<InventorySlot> it = li.iterator();
            while (it.hasNext()) {
                InventorySlot slot = it.next();
                if (is.field_77990_d != null && !is.field_77990_d.equals((Object)slot.getStack().field_77990_d)) continue;
                int dec = slot.decrement(amt);
                rem += dec;
                amt -= dec;
                if (slot.isEmpty()) {
                    it.remove();
                }
                if (amt > 0) continue;
                return rem;
            }
        }
        if ((li2 = this.dsus.get(is)) != null) {
            Iterator<IDeepStorageUnit> it = li2.iterator();
            while (it.hasNext()) {
                IDeepStorageUnit dsu = it.next();
                if (is.field_77990_d != null && !is.field_77990_d.equals((Object)dsu.getStoredItemType().field_77990_d)) continue;
                int has = dsu.getStoredItemType().field_77994_a;
                int dec = Math.min(amt, has);
                rem += dec;
                amt -= dec;
                dsu.setStoredItemCount(has - dec);
                if (dsu.getStoredItemType() == null || dsu.getStoredItemType().field_77994_a == 0) {
                    it.remove();
                }
                if (amt > 0) continue;
                return rem;
            }
        }
        return rem;
    }

    public void clear() {
        this.data.clear();
    }

    public String toString() {
        return this.data.toString();
    }

    private static abstract class InventoryInterface {
        private final IInventory inventory;

        private InventoryInterface(IInventory ii) {
            this.inventory = ii;
        }

        protected abstract void removeItem(ItemStack var1, int var2);

        protected abstract void addItem(ItemStack var1, int var2);

        protected abstract int countItem(ItemStack var1);
    }
}

