/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class BumpMap {
    private int[][] data;
    private final Class reference;
    private final String path;
    private final int referenceOffset;

    public BumpMap(Class root, String name) {
        this(root, name, 127);
    }

    public BumpMap(Class root, String name, int offset) {
        this.reference = root;
        this.path = name;
        this.referenceOffset = offset;
        this.load();
    }

    private void load() {
        try {
            BufferedImage img = ImageIO.read(this.reference.getResourceAsStream(this.path));
            this.data = new int[img.getWidth()][img.getHeight()];
            for (int i = 0; i < img.getWidth(); ++i) {
                for (int k = 0; k < img.getHeight(); ++k) {
                    this.data[i][k] = ReikaColorAPI.HexToGS(img.getRGB(i, k)) - this.referenceOffset;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getBump(int x, int y) {
        return this.data != null ? this.data[x][y] : 0;
    }

    public int getSizeX() {
        return this.data.length;
    }

    public int getSizeY() {
        return this.data[0].length;
    }
}

