/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultiBlockBlueprint {
    public final int xSize;
    public final int ySize;
    public final int zSize;
    protected Block[][][] IDs;
    protected int[][][] metas;
    private final List<Integer> overrides = new ArrayList<Integer>();
    protected static final Random rand = new Random();

    public MultiBlockBlueprint(int x, int y, int z) {
        this.xSize = x;
        this.ySize = y;
        this.zSize = z;
        this.IDs = new Block[x][y][z];
        this.metas = new int[x][y][z];
    }

    public MultiBlockBlueprint addBlockAt(int x, int y, int z, Block id, int meta) {
        this.IDs[x][y][z] = id;
        this.metas[x][y][z] = meta;
        return this;
    }

    public MultiBlockBlueprint addBlockAt(int x, int y, int z, Block id) {
        return this.addBlockAt(x, y, z, id, Short.MAX_VALUE);
    }

    public MultiBlockBlueprint addCenteredBlockAt(int x, int y, int z, Block id, int meta) {
        return this.addBlockAt(x + this.xSize / 2, y, z + this.zSize / 2, id, meta);
    }

    public MultiBlockBlueprint addCenteredBlockAt(int x, int y, int z, Block id) {
        return this.addCenteredBlockAt(x, y, z, id, Short.MAX_VALUE);
    }

    public boolean isMatch(World world, int x0, int y0, int z0) {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                for (int k = 0; k < this.zSize; ++k) {
                    Block b = world.func_147439_a(x0 + i, y0 + j, z0 + k);
                    int meta = world.func_72805_g(x0 + i, y0 + j, z0 + k);
                    if (b != this.IDs[i][j][k]) {
                        return false;
                    }
                    if (meta == this.metas[i][j][k] || this.metas[i][j][k] == Short.MAX_VALUE) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void createInWorld(World world, int x0, int y0, int z0) {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                for (int k = 0; k < this.zSize; ++k) {
                    Block id = this.IDs[i][j][k];
                    if (id == null) continue;
                    int meta = this.metas[i][j][k];
                    if (meta == Short.MAX_VALUE) {
                        meta = 0;
                    }
                    if (!this.canPlaceBlockAt(world, x0 + i, y0 + j, z0 + k)) continue;
                    world.func_147465_d(x0 + i, y0 + j, z0 + k, id, meta, 3);
                }
            }
        }
    }

    protected boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y, z)) {
            return true;
        }
        Block b = world.func_147439_a(x, y, z);
        return this.overrides.contains(b);
    }

    public MultiBlockBlueprint addOverwriteableID(int id) {
        this.overrides.add(id);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                for (int k = 0; k < this.zSize; ++k) {
                    Block id = this.IDs[i][j][k];
                    int meta = this.metas[i][j][k];
                    sb.append("[" + id + ":" + meta + "]");
                }
            }
        }
        return sb.toString();
    }

    public void clear() {
        this.IDs = new Block[this.xSize][this.ySize][this.zSize];
        this.metas = new int[this.xSize][this.ySize][this.zSize];
    }
}

