/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSpiral {
    private final BlockArray blocks = new BlockArray();
    private boolean rightHanded;
    public final int originX;
    public final int originY;
    public final int originZ;
    public final int radius;
    private int gridSize = 1;
    private int posX;
    private int posY;
    private int posZ;
    private ForgeDirection step = ForgeDirection.NORTH;

    public BlockSpiral(int x, int y, int z, int r) {
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.radius = r;
    }

    public BlockSpiral setRightHanded() {
        this.rightHanded = true;
        return this;
    }

    public BlockSpiral setGridSize(int s) {
        this.gridSize = s;
        return this;
    }

    public BlockSpiral setInitialDirection(ForgeDirection dir) {
        if (dir.offsetY != 0) {
            throw new MisuseException("Spirals are not designed for vertical directions!");
        }
        this.step = dir;
        return this;
    }

    public BlockSpiral calculate() {
        this.blocks.clear();
        this.posX = this.originX;
        this.posY = this.originY;
        this.posZ = this.originZ;
        this.blocks.addBlockCoordinate(this.posX, this.posY, this.posZ);
        while (Math.abs(this.posX - this.originX) <= this.radius * this.gridSize && Math.abs(this.posY - this.originY) <= this.radius * this.gridSize && Math.abs(this.posZ - this.originZ) <= this.radius * this.gridSize) {
            ForgeDirection dir;
            this.posX += this.step.offsetX * this.gridSize;
            this.posY += this.step.offsetY * this.gridSize;
            this.posZ += this.step.offsetZ * this.gridSize;
            this.blocks.addBlockCoordinate(this.posX, this.posY, this.posZ);
            ForgeDirection forgeDirection = dir = this.rightHanded ? ReikaDirectionHelper.getRightBy90(this.step) : ReikaDirectionHelper.getLeftBy90(this.step);
            if (this.blocks.hasBlock(this.posX + dir.offsetX * this.gridSize, this.posY + dir.offsetY * this.gridSize, this.posZ + dir.offsetZ * this.gridSize)) continue;
            this.step = dir;
        }
        return this;
    }

    public Coordinate getNthBlock(int n) {
        return this.blocks.getNthBlock(n);
    }

    public Coordinate getNextAndMoveOn() {
        return this.blocks.getNextAndMoveOn();
    }

    public int getSize() {
        return this.blocks.getSize();
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }
}

