/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.MusicScore;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public final class ReikaMIDIReader {
    public static final int NOTE_ON = 144;
    public static final int NOTE_OFF = 128;
    public static final int INSTRU_CHANGE = 192;
    public static final int TEMPO = 81;
    public static final String[] NOTE_NAMES = new String[]{"F#", "G", "G#", "A", "Bb", "B", "C", "C#", "D", "Eb", "E", "F"};
    public static final int MIDI_C5 = 60;

    private ReikaMIDIReader() {
        throw new RuntimeException("The class " + this.getClass() + " cannot be instantiated!");
    }

    public static Sequence getMIDIFromFile(Class root, String path, String back) {
        DragonAPICore.log("Reading MIDI at " + path + " with backup at " + back);
        InputStream input = root.getResourceAsStream(path);
        InputStream backup = root.getResourceAsStream(back);
        if (input == null && backup == null) {
            DragonAPICore.logError("Neither main file at " + path + " nor backup at " + back + " found. Aborting.");
            return null;
        }
        Sequencer seq = null;
        try {
            seq = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException e1) {
            DragonAPICore.logError("MIDI system unavailable.");
            return null;
        }
        try {
            seq.setSequence(input);
        }
        catch (IOException e1) {
            if (backup != null) {
                DragonAPICore.logError("MIDI File at " + path + " unreadable. Switching to backup.");
                try {
                    seq.setSequence(backup);
                }
                catch (IOException e) {
                    DragonAPICore.logError("Backup MIDI File at " + back + " unreadable.");
                }
                catch (InvalidMidiDataException e) {
                    DragonAPICore.logError("Backup MIDI File at " + back + " invalid.");
                }
            } else {
                DragonAPICore.logError("MIDI File at " + path + " unreadable, and no backup was available.");
            }
        }
        catch (InvalidMidiDataException e1) {
            if (backup != null) {
                DragonAPICore.log("MIDI File at " + path + " invalid. Switching to backup.");
                try {
                    seq.setSequence(backup);
                }
                catch (IOException e) {
                    DragonAPICore.logError("Backup MIDI File at " + back + " unreadable.");
                }
                catch (InvalidMidiDataException e) {
                    DragonAPICore.logError("Backup MIDI File at " + back + " invalid.");
                }
            }
            DragonAPICore.logError("MIDI File at " + path + " unreadable, and no backup was available.");
        }
        return seq.getSequence();
    }

    public static void debugMIDI(Sequence sequence) {
        if (sequence == null) {
            DragonAPICore.logError("Debugged MIDI is null!");
            return;
        }
        int trackNumber = 0;
        for (Track track : sequence.getTracks()) {
            System.out.println("Track " + ++trackNumber + ": size = " + track.size());
            System.out.println();
            for (int i = 0; i < track.size(); ++i) {
                MidiEvent event = track.get(i);
                System.out.print("@" + event.getTick() + " ");
                MidiMessage message = event.getMessage();
                if (message instanceof ShortMessage) {
                    int velocity;
                    String noteName;
                    int note;
                    int octave;
                    int key;
                    ShortMessage sm = (ShortMessage)message;
                    System.out.print("Channel: " + sm.getChannel() + " ");
                    if (sm.getCommand() == 144) {
                        key = sm.getData1();
                        octave = key / 12 - 1;
                        note = key % 12;
                        noteName = NOTE_NAMES[note];
                        velocity = sm.getData2();
                        System.out.println("Note on, " + noteName + octave + " key=" + key + " velocity: " + velocity);
                        continue;
                    }
                    if (sm.getCommand() == 128) {
                        key = sm.getData1();
                        octave = key / 12 - 1;
                        note = key % 12;
                        noteName = NOTE_NAMES[note];
                        velocity = sm.getData2();
                        System.out.println("Note off, " + noteName + octave + " key=" + key + " velocity: " + velocity);
                        continue;
                    }
                    if (sm.getCommand() == 192) {
                        System.out.println("Instrument change " + sm.getCommand());
                        continue;
                    }
                    System.out.println("Command:" + sm.getCommand());
                    continue;
                }
                System.out.println("Other message: " + message.getClass());
            }
            System.out.println();
        }
    }

    public static int getMidiLength(Sequence seq) {
        return ReikaMIDIReader.getSequenceLength(seq);
    }

    private static int getSequenceLength(Sequence seq) {
        if (seq == null) {
            return 0;
        }
        Track[] tr = seq.getTracks();
        int length = 0;
        for (int i = 0; i < tr.length; ++i) {
            if (tr[i].size() <= length) continue;
            length = tr[i].size();
        }
        return length;
    }

    public static int MIDITickToMCTick(Sequence seq, long ti) {
        return (int)((float)ti * ReikaMIDIReader.getMillisPerTick(seq) / 5.0f);
    }

    public static long MCTickToMIDITick(Sequence seq, int ti) {
        return (long)((float)ti / ReikaMIDIReader.getMillisPerTick(seq) * 5.0f);
    }

    private static float getMillisPerTick(Sequence seq) {
        float bpm = 90.0f;
        return 60000.0f / ((float)seq.getResolution() * bpm);
    }

    private static long getMIDITickLength(Sequence seq) {
        if (seq == null) {
            return 0L;
        }
        Track[] tr = seq.getTracks();
        long length = 0L;
        for (int i = 0; i < tr.length; ++i) {
            if ((long)tr[i].size() <= length) continue;
            length = tr[i].ticks();
        }
        return length;
    }

    private static int getMCTickLength(Sequence seq) {
        return ReikaMIDIReader.MIDITickToMCTick(seq, ReikaMIDIReader.getMIDITickLength(seq));
    }

    public static int[][][] readMIDIFileToArray(Sequence seq) {
        int[][][] data = new int[ReikaMIDIReader.getMCTickLength(seq)][64][3];
        if (seq == null) {
            DragonAPICore.logError("Sequence is empty!");
            return data;
        }
        int[][] dataline = new int[16][3];
        int vol = 0;
        int voice = 0;
        int note = 0;
        int instru = 0;
        Track[] tr = seq.getTracks();
        for (int i = 0; i < tr.length; ++i) {
            for (int j = 0; j < tr[i].size(); ++j) {
                MidiEvent event = tr[i].get(j);
                int time = ReikaMIDIReader.MIDITickToMCTick(seq, event.getTick());
                MidiMessage message = event.getMessage();
                if (!(message instanceof ShortMessage)) continue;
                ShortMessage sm = (ShortMessage)message;
                int channel = i - 1;
                if (channel == -1) {
                    throw new RuntimeException("Invalid MIDI has notes in the tempo track (track 0)!");
                }
                switch (sm.getCommand()) {
                    case 144: {
                        int key = sm.getData1();
                        int octave = key / 12 - 1;
                        int relnote = key % 12;
                        note = key - 24;
                        vol = sm.getData2();
                        voice = instru;
                        int a = 0;
                        dataline[channel][0] = ReikaMIDIReader.getNoteblockFromGM(voice);
                        if (dataline[channel][0] == 2) {
                            a = 12;
                        }
                        if (dataline[channel][0] == 3) {
                            a = -12;
                        }
                        dataline[channel][1] = note + a;
                        dataline[channel][2] = vol;
                        break;
                    }
                    case 128: {
                        break;
                    }
                    case 192: {
                        instru = sm.getData1();
                    }
                }
                if (dataline[channel][0] == 0 || sm.getCommand() != 144) continue;
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 3; ++l) {
                        data[time][k][l] = dataline[k][l];
                    }
                }
            }
        }
        return data;
    }

    public static MusicScore readMIDIFileToScore(Sequence seq) {
        MusicScore data = new MusicScore(16);
        if (seq == null) {
            DragonAPICore.logError("Sequence is empty!");
            return data;
        }
        int key = 0;
        int instru = 0;
        Track[] tr = seq.getTracks();
        for (int i = 0; i < tr.length; ++i) {
            MIDINote[] lastOn = new MIDINote[256];
            for (int j = 0; j < tr[i].size(); ++j) {
                MidiEvent event = tr[i].get(j);
                int time = ReikaMIDIReader.MIDITickToMCTick(seq, event.getTick());
                MidiMessage message = event.getMessage();
                if (!(message instanceof ShortMessage)) continue;
                ShortMessage sm = (ShortMessage)message;
                int channel = i;
                if (channel == 0) {
                    throw new RuntimeException("Invalid MIDI has notes in the tempo track (track 0)!");
                }
                switch (sm.getCommand()) {
                    case 144: {
                        key = sm.getData1();
                        int vol = sm.getData2();
                        lastOn[key] = new MIDINote(event.getTick(), time, key, instru, vol);
                        break;
                    }
                    case 128: {
                        break;
                    }
                    case 192: {
                        instru = sm.getData1();
                    }
                }
                if (lastOn[key] == null || sm.getCommand() != 128) continue;
                MIDINote m = lastOn[key];
                int len = time - m.timeOn;
                ReikaMusicHelper.MusicKey note = ReikaMusicHelper.MusicKey.getKeyFromMIDI(key);
                data.addNote(m.timeOn, channel - 1, note, m.voice, m.velocity, len);
                lastOn[key] = null;
            }
        }
        return data;
    }

    public static int getNoteblockFromGM(int v) {
        switch (v) {
            case 0: {
                return 1;
            }
            case 32: {
                return 2;
            }
            case 18: {
                return 3;
            }
        }
        return 0;
    }

    private static class MIDINote {
        private final long tick;
        private final int timeOn;
        private final int pitch;
        private final int voice;
        private final int velocity;

        private MIDINote(long tk, int t, int key, int inst, int vol) {
            this.tick = tk;
            this.timeOn = t;
            this.pitch = key;
            this.velocity = vol;
            this.voice = inst;
        }

        public String toString() {
            return String.format("Tick: %d, P:%d, Vel:%d, Voice:%d, Time:%d", this.tick, this.pitch, this.velocity, this.voice, this.timeOn);
        }
    }
}

