/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.DragonAPICore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.jar.JarFile;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ReikaFileReader
extends DragonAPICore {
    public static int getFileLength(File f) {
        int len;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(f));
            lnr.skip(Long.MAX_VALUE);
            len = lnr.getLineNumber() + 1 + 1;
            lnr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not load file data due to " + e.getCause() + " and " + e.getClass() + " !");
        }
        return len;
    }

    public static BufferedReader getReader(File f) {
        try {
            return new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(InputStream in) {
        try {
            return new BufferedReader(new InputStreamReader(in));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(String path) {
        try {
            return new BufferedReader(new InputStreamReader(new FileInputStream(path)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(URL url, int timeout, ConnectionErrorHandler ch, DataFetcher f) {
        if (!ReikaFileReader.isInternetAccessible(timeout)) {
            if (ch != null) {
                ch.onNoInternet();
            }
            return null;
        }
        try {
            URLConnection c = url.openConnection();
            c.setConnectTimeout(timeout);
            if (f != null) {
                try {
                    f.fetchData(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return new BufferedReader(new InputStreamReader(c.getInputStream()));
        }
        catch (UnknownHostException e) {
            if (ch != null) {
                ch.onServerNotFound();
            }
        }
        catch (ConnectException e) {
            if (ch != null) {
                ch.onServerRedirected();
            }
        }
        catch (SocketTimeoutException e) {
            if (ch != null) {
                ch.onTimedOut();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean isInternetAccessible(int timeout) {
        try {
            URLConnection c = new URL("http://www.google.com").openConnection();
            c.setConnectTimeout(timeout);
            ((HttpURLConnection)c).getResponseCode();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static ArrayList<File> getAllFilesInFolder(File f, String ... ext) {
        ArrayList<File> li = new ArrayList<File>();
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File in = files[i];
                if (in.isDirectory()) {
                    li.addAll(ReikaFileReader.getAllFilesInFolder(in, ext));
                    continue;
                }
                if (ext == null) {
                    li.add(in);
                    continue;
                }
                for (int k = 0; k < ext.length; ++k) {
                    if (!in.getName().endsWith(ext[k])) continue;
                    li.add(in);
                }
            }
        }
        return li;
    }

    public static ArrayList<File> getAllFilesInFolder(File f) {
        return ReikaFileReader.getAllFilesInFolder(f, null);
    }

    public static String readTextFile(Class root, String path) {
        BufferedReader p;
        InputStream in = root.getResourceAsStream(path);
        StringBuilder sb = new StringBuilder();
        try {
            p = new BufferedReader(new InputStreamReader(in));
        }
        catch (NullPointerException e) {
            DragonAPICore.logError("File " + path + " does not exist!");
            return sb.toString();
        }
        int i = 0;
        try {
            String line = null;
            while ((line = p.readLine()) != null) {
                if (line.isEmpty()) continue;
                sb.append(line);
                ++i;
                sb.append("\n");
            }
            p.close();
        }
        catch (Exception e) {
            DragonAPICore.logError(e.getMessage() + " on loading line " + i);
        }
        return sb.toString();
    }

    public static ArrayList<String> getFileAsLines(String path, boolean printStackTrace) {
        return ReikaFileReader.getFileAsLines(ReikaFileReader.getReader(path), printStackTrace);
    }

    public static ArrayList<String> getFileAsLines(URL url, int timeout, boolean printStackTrace, ConnectionErrorHandler ch) {
        return ReikaFileReader.getFileAsLines(url, timeout, printStackTrace, ch, null);
    }

    public static ArrayList<String> getFileAsLines(URL url, int timeout, boolean printStackTrace, ConnectionErrorHandler ch, DataFetcher f) {
        BufferedReader r = ReikaFileReader.getReader(url, timeout, ch, f);
        return r != null ? ReikaFileReader.getFileAsLines(r, printStackTrace) : null;
    }

    public static ArrayList<String> getFileAsLines(File f, boolean printStackTrace) {
        return ReikaFileReader.getFileAsLines(ReikaFileReader.getReader(f), printStackTrace);
    }

    public static ArrayList<String> getFileAsLines(InputStream in, boolean printStackTrace) {
        return ReikaFileReader.getFileAsLines(ReikaFileReader.getReader(in), printStackTrace);
    }

    public static ArrayList<String> getFileAsLines(BufferedReader r, boolean printStackTrace) {
        ArrayList<String> li;
        block3: {
            li = new ArrayList<String>();
            String line = "";
            try {
                while (line != null) {
                    line = r.readLine();
                    if (line == null) continue;
                    li.add(line);
                }
                r.close();
            }
            catch (Exception e) {
                if (!printStackTrace) break block3;
                e.printStackTrace();
            }
        }
        return li;
    }

    public static void writeLinesToFile(String s, ArrayList<String> li, boolean printStackTrace) {
        ReikaFileReader.writeLinesToFile(new File(s), li, printStackTrace);
    }

    public static void writeLinesToFile(File f, ArrayList<String> li, boolean printStackTrace) {
        block2: {
            try {
                ReikaFileReader.writeLinesToFile(new BufferedWriter(new PrintWriter(f)), li, printStackTrace);
            }
            catch (IOException e) {
                if (!printStackTrace) break block2;
                e.printStackTrace();
            }
        }
    }

    public static void writeLinesToFile(BufferedWriter p, ArrayList<String> li, boolean printStackTrace) {
        block3: {
            String sep = System.getProperty("line.separator");
            try {
                for (String s : li) {
                    p.write(s + sep);
                }
                p.flush();
                p.close();
            }
            catch (IOException e) {
                if (!printStackTrace) break block3;
                e.printStackTrace();
            }
        }
    }

    public static String getHash(String path, HashType type) {
        return ReikaFileReader.getHash(new File(path), type);
    }

    public static String getHash(File file, HashType type) {
        try {
            return ReikaFileReader.getHash(new FileInputStream(file), type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getHash(InputStream is, HashType type) {
        StringBuffer sb = new StringBuffer();
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(type.tag);
            do {
                if ((numRead = is.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            is.close();
            byte[] hash = complete.digest();
            for (int i = 0; i < hash.length; ++i) {
                sb.append(Integer.toString((hash[i] & 0xFF) + 256, 16).substring(1).toUpperCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sb.append("IO ERROR: ");
            sb.append(e.toString());
        }
        return sb.toString();
    }

    public static InputStream getFileInsideJar(File f, String name) {
        try {
            return ReikaFileReader.getFileInsideJar(new JarFile(f), name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream getFileInsideJar(JarFile jar, String name) {
        try {
            return jar.getInputStream(jar.getEntry(name));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean deleteFolderWithContents(File f) {
        return ReikaFileReader.deleteFolderWithContents(f, 10);
    }

    public static boolean deleteFolderWithContents(File f, int tries) {
        Throwable e = null;
        for (int i = 0; i < tries; ++i) {
            try {
                FileUtils.forceDelete((File)f);
                return true;
            }
            catch (Exception ex) {
                e = ex;
                continue;
            }
        }
        if (e != null) {
            e.printStackTrace();
        }
        return false;
    }

    public static void copyFile(InputStream in, OutputStream out, int size) throws FileReadException, FileWriteException {
        ReikaFileReader.copyFile(in, out, size, null);
    }

    public static void copyFile(InputStream in, OutputStream out, int chunkSize, WriteCallback call) throws FileReadException, FileWriteException {
        byte[] bytes = new byte[chunkSize];
        int count = 0;
        while (count != -1) {
            if (count > 0) {
                try {
                    out.write(bytes, 0, count);
                    if (call != null) {
                        call.onWrite(bytes);
                    }
                }
                catch (IOException e) {
                    throw new FileWriteException(e);
                }
            }
            try {
                count = in.read(bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new FileReadException(e);
            }
        }
    }

    public static File createFileFromStream(InputStream in) throws IOException {
        File tempFile = File.createTempFile("temp_" + String.valueOf(in.hashCode()), null);
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        return tempFile;
    }

    public static void writeUncompressedNBT(NBTTagCompound tag, File f) throws IOException {
        ReikaFileReader.writeUncompressedNBT(tag, new FileOutputStream(f));
    }

    public static void writeUncompressedNBT(NBTTagCompound tag, OutputStream out) throws IOException {
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)new DataOutputStream(out));
    }

    public static NBTTagCompound readUncompressedNBT(File f) throws IOException {
        return ReikaFileReader.readUncompressedNBT(new FileInputStream(f));
    }

    public static NBTTagCompound readUncompressedNBT(InputStream in) throws IOException {
        return CompressedStreamTools.func_152456_a((DataInput)new DataInputStream(in), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
    }

    public static boolean isEmpty(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        String line = br.readLine();
        if (line == null || line.length() == 0 && br.readLine() == null) {
            br.close();
            return true;
        }
        br.close();
        return false;
    }

    public static void emptyDirectory(File dir) {
        File[] f = dir.listFiles();
        for (int i = 0; i < f.length; ++i) {
            f[i].delete();
        }
    }

    public static void clearFile(File f) {
        try {
            f.delete();
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface WriteCallback {
        public void onWrite(byte[] var1);
    }

    public static class FileWriteException
    extends IOException {
        private FileWriteException(IOException e) {
            super(e);
        }
    }

    public static class FileReadException
    extends IOException {
        private FileReadException(IOException e) {
            super(e);
        }
    }

    public static abstract class LineEditor {
        public abstract boolean editLine(String var1);

        protected abstract String getReplacementLine(String var1, String var2);

        public final boolean performChanges(File f) {
            try {
                BufferedReader r = new BufferedReader(new FileReader(f));
                String sep = System.getProperty("line.separator");
                String line = r.readLine();
                StringBuilder out = new StringBuilder();
                while (line != null) {
                    String rep;
                    String string = rep = this.editLine(line) ? this.getReplacementLine(line, sep) : line;
                    if (rep != null) {
                        out.append(rep + sep);
                    }
                    line = r.readLine();
                }
                r.close();
                FileOutputStream os = new FileOutputStream(f);
                os.write(out.toString().getBytes());
                os.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public static enum HashType {
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256");

        private final String tag;

        private HashType(String s) {
            this.tag = s;
        }
    }

    public static interface DataFetcher {
        public void fetchData(URLConnection var1) throws Exception;
    }

    public static interface ConnectionErrorHandler {
        public void onServerRedirected();

        public void onTimedOut();

        public void onNoInternet();

        public void onServerNotFound();
    }
}

