/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EditNearbyInventoryCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        int z;
        int y;
        EntityPlayerMP ep = EditNearbyInventoryCommand.func_71521_c((ICommandSender)ics);
        if (args.length != 5) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, EnumChatFormatting.RED + "You must specify an action, a range, and an ItemStack.");
            return;
        }
        ItemStack is = this.parseItem(args[2], args[3], args[4]);
        if (is == null) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, EnumChatFormatting.RED + "No such item '" + args[2] + "'.");
            return;
        }
        Mode mode = Mode.get(args[0]);
        if (mode == null) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, EnumChatFormatting.RED + "No such action '" + args[0] + "'.");
            return;
        }
        int r = ReikaJavaLibrary.safeIntParse(args[1]);
        if (r <= 0) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, EnumChatFormatting.RED + "Invalid range '" + args[1] + "'.");
            return;
        }
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int num = mode.perform(ep.field_70170_p, x, y = MathHelper.func_76128_c((double)ep.field_70163_u), z = MathHelper.func_76128_c((double)ep.field_70161_v), is, r);
        if (num < 0) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, EnumChatFormatting.RED + "No inventories within range.");
            return;
        }
        String base = "%sSuccessfully %s inventories for %s within%s%s%d blocks of %d, %d, %d. %s%s";
        String act = mode == Mode.COUNT ? num + " items present." : num + "/" + is.field_77994_a + " changes made.";
        String g = EnumChatFormatting.GREEN.toString();
        String s = String.format(base, g, args[0], is.toString(), "\n", g, r, x, y, z, EnumChatFormatting.GOLD.toString(), act);
        ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, s);
    }

    private ItemStack parseItem(String item, String damage, String size) {
        int meta = Integer.parseInt(damage);
        int num = Integer.parseInt(size);
        int id = -1;
        try {
            id = Integer.parseInt(item);
        }
        catch (Exception e) {
            // empty catch block
        }
        Item i = id > 0 ? Item.func_150899_d((int)id) : (Item)Item.field_150901_e.func_82594_a(item);
        return i != null ? new ItemStack(i, num, meta) : null;
    }

    @Override
    public String getCommandString() {
        return "nearinv";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }

    private static enum Mode {
        COUNT,
        ADD,
        REMOVE;


        private static Mode get(String mode) {
            for (int i = 0; i < Mode.values().length; ++i) {
                Mode m = Mode.values()[i];
                if (!m.name().toLowerCase(Locale.ENGLISH).equals(mode.toLowerCase(Locale.ENGLISH))) continue;
                return m;
            }
            return null;
        }

        public int perform(World world, int x, int y, int z, ItemStack is, int r) {
            Collection<IInventory> c = ReikaWorldHelper.getAllInventories(world, x, y, z, r);
            if (c.isEmpty()) {
                return -1;
            }
            int count = 0;
            for (IInventory ii : c) {
                ItemStack is2;
                if (this == COUNT || this == REMOVE) {
                    int s = ii.func_70302_i_();
                    for (int i = 0; i < s; ++i) {
                        ItemStack in = ii.func_70301_a(i);
                        if (!ReikaItemHelper.matchStacks(is, in)) continue;
                        if (this == REMOVE) {
                            int num = Math.min(is.field_77994_a - count, in.field_77994_a);
                            count += num;
                            in.field_77994_a -= num;
                            if (in.field_77994_a <= 0) {
                                ii.func_70299_a(i, null);
                            }
                            if (count < is.field_77994_a) continue;
                            return count;
                        }
                        count += in.field_77994_a;
                    }
                }
                if (this != ADD || (count += is2.field_77994_a - ReikaInventoryHelper.addToInventoryWithLeftover(is2 = ReikaItemHelper.getSizedItemStack(is, is.field_77994_a - count), ii, false)) < is.field_77994_a) continue;
                return count;
            }
            return count;
        }
    }
}

