/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.CustomBiomeDistributionWorld;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.biome.BiomeGenMushroomIsland;
import net.minecraft.world.biome.BiomeGenMutated;
import net.minecraft.world.biome.BiomeGenRiver;

public class BiomeMapCommand
extends DragonCommandBase {
    public static final int PACKET_COMPILE = 2048;
    private static final Random rand = new Random();
    private static final HashMap<Integer, BiomeMap> activeMaps = new HashMap();

    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length < 2) {
            BiomeMapCommand.sendChatToSender(ics, EnumChatFormatting.RED.toString() + "Illegal arguments. Use [range] [resolution] <grid> <fullGrid>.");
            return;
        }
        int range = Integer.parseInt(args[0]);
        int res = Integer.parseInt(args[1]);
        int grid = args.length >= 3 ? Integer.parseInt(args[2]) : -1;
        boolean fullGrid = grid > 0 && args.length >= 4 && Boolean.parseBoolean(args[3]);
        EntityPlayerMP ep = BiomeMapCommand.func_71521_c((ICommandSender)ics);
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        long start = System.currentTimeMillis();
        int hash = rand.nextInt();
        String name = ep.field_70170_p.func_72912_H().func_76065_j();
        int dim = ep.field_70170_p.field_73011_w.field_76574_g;
        ReikaPacketHelper.sendStringIntPacket("DragonAPIData", APIPacketHandler.PacketIDs.BIOMEPNGSTART.ordinal(), ep, name, hash, dim, x, z, range, res, grid, fullGrid ? 1 : 0);
        ArrayList<Integer> dat = new ArrayList<Integer>();
        dat.add(hash);
        int n = 0;
        for (int dx = x - range; dx <= x + range; dx += res) {
            for (int dz = z - range; dz <= z + range; dz += res) {
                int biome = this.getBiome(ep.field_70170_p, dx, dz);
                ++n;
                dat.add(dx);
                dat.add(dz);
                dat.add(biome);
                if (n < 2048) continue;
                ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.BIOMEPNGDAT.ordinal(), ep, dat);
                n = 0;
                dat.clear();
                dat.add(hash);
            }
        }
        if (dat.size() > 1) {
            int m = (dat.size() - 1) / 3;
            int biome = this.getBiome(ep.field_70170_p, x, z);
            for (int i = m; i < 2048; ++i) {
                dat.add(x);
                dat.add(z);
                dat.add(biome);
            }
            ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.BIOMEPNGDAT.ordinal(), ep, dat);
            n = 0;
            dat.clear();
            dat.add(hash);
        }
        ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.BIOMEPNGEND.ordinal(), ep, hash);
    }

    private int getBiome(World world, int x, int z) {
        if (world.field_73011_w instanceof CustomBiomeDistributionWorld) {
            return ((CustomBiomeDistributionWorld)world.field_73011_w).getBiomeID(world, x, z);
        }
        return world.func_72807_a((int)x, (int)z).field_76756_M;
    }

    @Override
    public String getCommandString() {
        return "biomepng";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void startCollecting(int hash, String world, int dim, int x, int z, int range, int res, int grid, boolean fullGrid) {
        BiomeMap map = new BiomeMap(world, dim, x, z, range, res, grid, fullGrid);
        activeMaps.put(hash, map);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addBiomePoint(int hash, int x, int z, int biomeID) {
        BiomeMap map = activeMaps.get(hash);
        if (map != null) {
            map.addPoint(x, z, biomeID);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void finishCollectingAndMakeImage(int hash) {
        BiomeMap map = activeMaps.remove(hash);
        if (map != null) {
            try {
                map.addGrid();
                String path = map.createImage();
                long dur = System.currentTimeMillis() - map.startTime;
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumChatFormatting.GREEN + "File created in " + dur + " ms: " + path);
            }
            catch (IOException e) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumChatFormatting.RED + "Failed to create file: " + e.toString());
                e.printStackTrace();
            }
        }
    }

    private static class BiomeMap {
        private final String worldName;
        private final int dimensionID;
        private final int originX;
        private final int originZ;
        private final int range;
        private final int resolution;
        private final int gridSize;
        private final boolean fullGrid;
        private final long startTime = System.currentTimeMillis();
        private final int[][] data;

        private BiomeMap(String name, int dim, int x, int z, int r, int res, int grid, boolean fgrid) {
            this.worldName = name;
            this.dimensionID = dim;
            this.originX = x;
            this.originZ = z;
            this.range = r;
            this.resolution = res;
            this.gridSize = grid;
            this.fullGrid = fgrid;
            this.data = new int[this.range * 2 / this.resolution + 1][this.range * 2 / this.resolution + 1];
        }

        private void addGrid() {
            if (this.gridSize > 0) {
                for (int dx = this.originX - this.range; dx <= this.originX + this.range; dx += this.resolution) {
                    for (int dz = this.originZ - this.range; dz <= this.originZ + this.range; dz += this.resolution) {
                        boolean flag2;
                        int i = (this.range + (dx - this.originX)) / this.resolution;
                        int k = (this.range + (dz - this.originZ)) / this.resolution;
                        int i2 = dx - this.originX;
                        int k2 = dz - this.originZ;
                        boolean flag1 = i2 % this.gridSize == 0;
                        boolean bl = flag2 = k2 % this.gridSize == 0;
                        if (!flag1 && !flag2 || (!flag1 || !flag2) && !this.fullGrid) continue;
                        this.data[i][k] = ReikaColorAPI.mixColors(this.data[i][k], i2 == 0 && k2 == 0 ? -65536 : -1, 0.25f);
                        if (i - 1 >= 0) {
                            this.data[i - 1][k] = ReikaColorAPI.mixColors(this.data[i - 1][k], -16777216, 0.5f);
                        }
                        if (i + 1 < this.data.length) {
                            this.data[i + 1][k] = ReikaColorAPI.mixColors(this.data[i + 1][k], -16777216, 0.5f);
                        }
                        if (k - 1 >= 0) {
                            this.data[i][k - 1] = ReikaColorAPI.mixColors(this.data[i][k - 1], -16777216, 0.5f);
                        }
                        if (k + 1 >= this.data[i].length) continue;
                        this.data[i][k + 1] = ReikaColorAPI.mixColors(this.data[i][k + 1], -16777216, 0.5f);
                    }
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void addPoint(int x, int z, int biomeID) {
            int c = 0xFF000000 | this.getBiomeColor((World)Minecraft.func_71410_x().field_71441_e, x, z, BiomeGenBase.field_76773_a[biomeID]);
            int i = (this.range + (x - this.originX)) / this.resolution;
            int k = (this.range + (z - this.originZ)) / this.resolution;
            this.data[i][k] = c;
        }

        @SideOnly(value=Side.CLIENT)
        private String createImage() throws IOException {
            String name = this.getFilename();
            File f = new File(DragonAPICore.getMinecraftDirectory(), name);
            if (f.exists()) {
                f.delete();
            }
            f.getParentFile().mkdirs();
            f.createNewFile();
            BufferedImage img = new BufferedImage(this.data.length, this.data.length, 2);
            for (int i = 0; i < this.data.length; ++i) {
                for (int k = 0; k < this.data[i].length; ++k) {
                    img.setRGB(i, k, this.data[i][k]);
                }
            }
            ImageIO.write((RenderedImage)img, "png", f);
            return f.getAbsolutePath();
        }

        private String getFilename() {
            String sr = String.valueOf(this.range * 2 + 1);
            return "BiomeMap/" + this.worldName + "/DIM" + this.dimensionID + "/" + this.originX + ", " + this.originZ + " (" + sr + "x" + sr + "; [R=" + this.resolution + " b-px, G=" + this.gridSize + "-" + this.fullGrid + "]).png";
        }

        @SideOnly(value=Side.CLIENT)
        private int getBiomeColor(World world, int x, int z, BiomeGenBase b) {
            if (b == null) {
                return 0;
            }
            boolean mutate = b instanceof BiomeGenMutated;
            if (mutate) {
                b = ((BiomeGenMutated)b).field_150611_aD;
            }
            if (b == BiomeGenBase.field_76778_j) {
                return 12658179;
            }
            if (b == BiomeGenBase.field_76779_k) {
                return 16771491;
            }
            if (b == BiomeGenBase.field_76776_l) {
                return 65535;
            }
            if (b.field_76756_M == BiomeGenBase.field_76774_n.field_76756_M + 128) {
                return 0x7FFFFF;
            }
            if (b.field_76791_y.equalsIgnoreCase("Shield")) {
                return 3702605;
            }
            if (b.field_76791_y.equalsIgnoreCase("Tropics")) {
                return 65280;
            }
            if (b.field_76791_y.equalsIgnoreCase("Lush Swamp")) {
                return 36864;
            }
            if (b.field_76791_y.equalsIgnoreCase("Bayou")) {
                return 8093519;
            }
            if (ReikaBiomeHelper.isOcean(b)) {
                if (b == BiomeGenBase.field_150575_M) {
                    return 176;
                }
                return 255;
            }
            if (b instanceof BiomeGenRiver) {
                return 0x22AAFF;
            }
            if (b instanceof BiomeGenMesa) {
                return mutate ? 13529938 : 12866603;
            }
            if (b instanceof BiomeGenMushroomIsland) {
                return 9852017;
            }
            if (b == BiomeGenBase.field_150578_U || b == BiomeGenBase.field_150581_V) {
                return 10184761;
            }
            if (b.field_76752_A == Blocks.field_150354_m) {
                return 14862741;
            }
            if (b.field_76752_A == Blocks.field_150348_b) {
                return 0x808080;
            }
            if (b.field_76791_y.equalsIgnoreCase("Coniferous Forest")) {
                return 32578;
            }
            if (b.field_76791_y.equalsIgnoreCase("Maple Forest")) {
                return 3833682;
            }
            if (b.field_76791_y.equalsIgnoreCase("Rainbow Forest")) {
                return 0x8888FF;
            }
            if (b.field_76791_y.equalsIgnoreCase("Ender Forest")) {
                return 13136603;
            }
            if (b.field_76791_y.equalsIgnoreCase("Luminous Cliffs")) {
                return 0x22AAFF;
            }
            if (ReikaBiomeHelper.isSnowBiome(b)) {
                return 0xFFFFFF;
            }
            int c = b.func_150558_b(x, 64, z);
            if (mutate) {
                c = ReikaColorAPI.getColorWithBrightnessMultiplier(c, 0.875f);
            } else if (ReikaBiomeHelper.isChildBiome(b)) {
                c = ReikaColorAPI.getColorWithBrightnessMultiplier(c, 1.125f);
            }
            return c;
        }
    }
}

