/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.IO.ModLogger;
import Reika.DragonAPI.ModList;
import java.util.Collection;

public class SuggestedModsTracker {
    private final MultiMap<DragonAPIMod, SuggestedMod> data = new MultiMap();
    public static final SuggestedModsTracker instance = new SuggestedModsTracker();

    private SuggestedModsTracker() {
    }

    public void addSuggestedMod(DragonAPIMod mod, ModList suggested, String reason) {
        SuggestedMod s = new SuggestedMod(suggested, reason);
        this.data.addValue(mod, s);
    }

    public void addSuggestedMods(DragonAPIMod mod, String reason, ModList ... suggested) {
        for (int i = 0; i < suggested.length; ++i) {
            this.addSuggestedMod(mod, suggested[i], reason);
        }
    }

    public void printConsole(DragonAPIMod mod) {
        ModLogger log = mod.getModLogger();
        Collection<SuggestedMod> li = this.data.get(mod);
        for (SuggestedMod sug : li) {
            if (sug.isLoaded()) continue;
            String s = String.format("Consider installing %s: %s", sug.getName(), sug.reason);
            log.log(s);
        }
    }

    public void printConsole() {
        for (DragonAPIMod mod : this.data.keySet()) {
            this.printConsole(mod);
        }
    }

    private static class SuggestedMod {
        public final String reason;
        public final ModList mod;

        private SuggestedMod(ModList mod, String reason) {
            this.reason = reason;
            this.mod = mod;
        }

        public String getName() {
            return this.mod.getDisplayName();
        }

        public boolean isLoaded() {
            return this.mod.isLoaded();
        }

        public boolean equals(Object o) {
            if (o instanceof SuggestedMod) {
                SuggestedMod mod = (SuggestedMod)o;
                return this.mod == mod.mod;
            }
            return false;
        }
    }
}

