/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;

public class RetroGenController {
    public static final RetroGenController instance = new RetroGenController();
    private static final String NBT_TAG = "DRAGONAPI_RETROGEN";
    private static final GenComparator genComparator = new GenComparator();
    private ArrayList<RetroactiveGenerator> retrogens = new ArrayList();
    private HashMap<String, Integer> retrogenOrder = new HashMap();
    private Collection<ChunkData> chunks = new ArrayList<ChunkData>();
    private Collection<ChunkData> scheduledAdds = new ArrayList<ChunkData>();
    private boolean allowAdd = true;
    private boolean allowTick = true;

    private RetroGenController() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        TickRegistry.instance.registerTickHandler(new RetrogenTicker());
    }

    public void addRetroGenerator(RetroactiveGenerator gen, int weight) {
        this.retrogens.add(gen);
        this.retrogenOrder.put(gen.getIDString(), weight);
        Collections.sort(this.retrogens, genComparator);
    }

    public void addHybridGenerator(RetroactiveGenerator gen, int weight, boolean retro) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)gen, (int)weight);
        if (retro) {
            this.addRetroGenerator(gen, weight);
        }
    }

    @SubscribeEvent
    public void loadChunk(ChunkDataEvent.Load event) {
        if (this.retrogens.isEmpty()) {
            return;
        }
        ChunkData cd = new ChunkData(event);
        if (this.allowAdd) {
            this.allowTick = false;
            this.chunks.add(cd);
            this.chunks.addAll(this.scheduledAdds);
            this.scheduledAdds.clear();
            this.allowTick = true;
        } else {
            this.scheduledAdds.add(cd);
        }
    }

    private boolean generate(World world, ChunkCoordIntPair pos, RetroactiveGenerator gen) {
        if (!gen.canGenerateAt(world.field_73012_v, world, pos.field_77276_a, pos.field_77275_b)) {
            return false;
        }
        IChunkProvider prov = world.func_72863_F();
        IChunkProvider generator = ((ChunkProviderServer)prov).field_73246_d;
        gen.generate(world.field_73012_v, pos.field_77276_a, pos.field_77275_b, world, generator, prov);
        return true;
    }

    private static class ChunkData {
        private final ChunkCoordIntPair position;
        private final NBTTagCompound data;

        private ChunkData(ChunkDataEvent.Load evt) {
            this.position = new ChunkCoordIntPair(evt.getChunk().field_76635_g, evt.getChunk().field_76647_h);
            this.data = evt.getData();
        }
    }

    private static class GenComparator
    implements Comparator<RetroactiveGenerator> {
        private GenComparator() {
        }

        @Override
        public int compare(RetroactiveGenerator o1, RetroactiveGenerator o2) {
            int n2;
            int n1 = (Integer)instance.retrogenOrder.get(o1.getIDString());
            return n1 == (n2 = ((Integer)instance.retrogenOrder.get(o2.getIDString())).intValue()) ? 0 : (n1 < n2 ? -1 : 1);
        }
    }

    private static class RetrogenTicker
    implements TickRegistry.TickHandler {
        private RetrogenTicker() {
        }

        @Override
        public void tick(TickRegistry.TickType type, Object ... tickData) {
            if (!instance.allowTick) {
                return;
            }
            World world = (World)tickData[0];
            instance.allowAdd = false;
            for (ChunkData dat : instance.chunks) {
                boolean genned = false;
                for (RetroactiveGenerator gen : instance.retrogens) {
                    if (!this.shouldRun(gen, dat)) continue;
                    boolean flag = instance.generate(world, dat.position, gen);
                    this.markChunkGenned(dat.data, gen, flag);
                    if (!flag) continue;
                    genned = true;
                }
                if (!genned) continue;
                int dx = ((ChunkData)dat).position.field_77276_a * 16;
                int dz = ((ChunkData)dat).position.field_77275_b * 16;
                world.func_147449_b(dx, 128, dz, Blocks.field_150336_V);
                world.func_147449_b(dx + 15, 128, dz, Blocks.field_150336_V);
                world.func_147449_b(dx + 15, 128, dz + 15, Blocks.field_150336_V);
                world.func_147449_b(dx, 128, dz + 15, Blocks.field_150336_V);
            }
            instance.chunks.clear();
            instance.allowAdd = true;
        }

        private boolean shouldRun(RetroactiveGenerator gen, ChunkData dat) {
            return !dat.data.func_74775_l(RetroGenController.NBT_TAG).func_74767_n(gen.getIDString());
        }

        private void markChunkGenned(NBTTagCompound data, RetroactiveGenerator gen, boolean flag) {
            NBTTagCompound base = data.func_74775_l(RetroGenController.NBT_TAG);
            base.func_74757_a(gen.getIDString(), flag);
            data.func_74782_a(RetroGenController.NBT_TAG, (NBTBase)base);
        }

        @Override
        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.WORLD);
        }

        @Override
        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.START;
        }

        @Override
        public String getLabel() {
            return "DragonAPI Retrogen";
        }
    }
}

