/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerFirstTimeTracker {
    private static final String BASE_TAG = "DragonAPI_PlayerTracker_";
    private static final ArrayList<PlayerTracker> list = new ArrayList();
    private static final ArrayList<String> tags = new ArrayList();

    public static void addTracker(PlayerTracker pt) {
        String s = pt.getID();
        if (tags.contains(s)) {
            throw new MisuseException("Duplicate PlayerTracker ID: " + s);
        }
        DragonAPICore.log("Creating player tracker " + s);
        list.add(pt);
        tags.add(s);
    }

    public static void checkPlayer(EntityPlayer ep) {
        NBTTagCompound nbt = ep.getEntityData();
        for (PlayerTracker pt : list) {
            if (PlayerFirstTimeTracker.hasPlayer(pt, ep)) continue;
            pt.onNewPlayer(ep);
            PlayerFirstTimeTracker.addPlayer(pt, ep);
        }
    }

    private static void addPlayer(PlayerTracker pt, EntityPlayer ep) {
        String tag = BASE_TAG + pt.getID();
        ReikaPlayerAPI.getDeathPersistentNBT(ep).func_74757_a(tag, true);
    }

    private static boolean hasPlayer(PlayerTracker pt, EntityPlayer ep) {
        String tag = BASE_TAG + pt.getID();
        return ReikaPlayerAPI.getDeathPersistentNBT(ep).func_74767_n(tag);
    }

    public static interface PlayerTracker {
        public void onNewPlayer(EntityPlayer var1);

        public String getID();
    }
}

