/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLoginEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ModFileVersionChecker {
    public static final ModFileVersionChecker instance = new ModFileVersionChecker();
    private final HashMap<String, String> data = new HashMap();

    private ModFileVersionChecker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addMod(DragonAPIMod mod) {
        this.data.put(mod.getModContainer().getModId(), mod.getFileHash());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void dispatch(ClientLoginEvent evt) {
        for (String mod : this.data.keySet()) {
            String s = mod + ":" + this.data.get(mod);
            ReikaPacketHelper.sendStringIntPacket("DragonAPIData", APIPacketHandler.PacketIDs.FILEMATCH.ordinal(), new PacketTarget.ServerTarget(), s, new int[0]);
        }
    }

    public void checkFiles(EntityPlayerMP ep, String s) {
        boolean flag = false;
        String[] parts = s.split(":");
        if (parts.length != 2) {
            flag = true;
        }
        String mod = parts[0];
        String hash = this.data.get(mod);
        if (!flag && hash != null) {
            boolean bl = flag = !hash.equals(parts[1]);
        }
        if (flag) {
            this.kick(ep, mod, parts[1], hash);
        } else {
            DragonAPICore.log("Player " + ep.func_70005_c_() + " passed hash check for " + mod + ". Hash: " + hash);
        }
    }

    private void kick(EntityPlayerMP ep, String mod, String client, String server) {
        HashKickEvent evt = new HashKickEvent((EntityPlayer)ep, mod, client, server);
        if (!MinecraftForge.EVENT_BUS.post((Event)evt)) {
            String msg = mod + " jarfile mismatch. Client Hash: " + client + "; Expected (Server) Hash: " + server;
            ReikaPlayerAPI.kickPlayer(ep, msg);
            DragonAPICore.log("Player " + ep.func_70005_c_() + " kicked due to " + msg);
        } else {
            DragonAPICore.log("Player " + ep.func_70005_c_() + " not kicked for hash mismatch; kick cancelled");
        }
    }

    @Cancelable
    public static class HashKickEvent
    extends PlayerEvent {
        public final String serverHash;
        public final String clientHash;
        public final String mod;

        public HashKickEvent(EntityPlayer player, String mod, String client, String server) {
            super(player);
            this.mod = mod;
            this.serverHash = server;
            this.clientHash = client;
        }
    }
}

