/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.ModIntegrityException;
import Reika.DragonAPI.Interfaces.Registry.BlockEnum;
import Reika.DragonAPI.Interfaces.Registry.ItemEnum;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public final class IntegrityChecker {
    public static final IntegrityChecker instance = new IntegrityChecker();
    private final HashMap<DragonAPIMod, BlockEnum[]> modBlocks = new HashMap();
    private final HashMap<DragonAPIMod, ItemEnum[]> modItems = new HashMap();

    private IntegrityChecker() {
    }

    public void addMod(DragonAPIMod mod, BlockEnum[] blocks, ItemEnum[] items) {
        this.modBlocks.put(mod, blocks);
        this.modItems.put(mod, items);
    }

    private Tamper testBlockIntegrity(DragonAPIMod mod) {
        BlockEnum[] blocks = this.modBlocks.get(mod);
        for (int i = 0; i < blocks.length; ++i) {
            BlockEnum ir = blocks[i];
            if (ir.isDummiedOut()) continue;
            Block b = ir.getBlockInstance();
            if (b == null) {
                return new Tamper(TamperType.DELETION, ir.getBasicName());
            }
            if (ir.getObjectClass() == b.getClass()) continue;
            return new Tamper(TamperType.OVERWRITE, ir.getBasicName());
        }
        return null;
    }

    private Tamper testItemIntegrity(DragonAPIMod mod) {
        ItemEnum[] items = this.modItems.get(mod);
        for (int i = 0; i < items.length; ++i) {
            ItemEnum ir = items[i];
            if (ir.isDummiedOut()) continue;
            Item b = ir.getItemInstance();
            if (b == null) {
                return new Tamper(TamperType.DELETION, ir.getBasicName());
            }
            if (ir.getObjectClass() == b.getClass()) continue;
            return new Tamper(TamperType.OVERWRITE, ir.getBasicName());
        }
        return null;
    }

    public void testIntegrity() {
        Tamper t;
        for (DragonAPIMod mod : this.modBlocks.keySet()) {
            t = this.testBlockIntegrity(mod);
            if (t == null) continue;
            throw new ModIntegrityException(mod, t.toString());
        }
        for (DragonAPIMod mod : this.modItems.keySet()) {
            t = this.testItemIntegrity(mod);
            if (t == null) continue;
            throw new ModIntegrityException(mod, t.toString());
        }
    }

    private static enum TamperType {
        DELETION,
        OVERWRITE;

    }

    private class Tamper {
        public final TamperType editType;
        public final String tamperedElement;

        public Tamper(TamperType type, String element) {
            this.tamperedElement = element;
            this.editType = type;
        }

        public String toString() {
            return ReikaStringParser.capFirstChar(this.editType.name()) + " of " + this.tamperedElement;
        }
    }
}

