/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLoginEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Configuration.BooleanConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Configuration.DecimalConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntegerConfig;
import Reika.DragonAPI.Interfaces.Configuration.MatchingConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringConfig;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;

public class ConfigMatcher {
    public static final ConfigMatcher instance = new ConfigMatcher();
    private final HashMap<String, Integer> data = new HashMap();
    private final PlayerMap<HashMap<String, Mismatch>> mismatch = new PlayerMap();
    private final PlayerMap<HashSet<String>> checkedValues = new PlayerMap();

    private ConfigMatcher() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addConfigList(DragonAPIMod mod, MatchingConfig[] cfg) {
        for (int i = 0; i < cfg.length; ++i) {
            if (!cfg[i].enforceMatch()) continue;
            this.addConfig(mod, cfg[i]);
        }
    }

    public void addConfig(DragonAPIMod mod, MatchingConfig cfg) {
        this.data.put(this.getString(mod, cfg), this.getInt(cfg));
    }

    private String getString(DragonAPIMod mod, ConfigList cfg) {
        return mod.getTechnicalName() + "::" + cfg.getLabel();
    }

    private int getInt(ConfigList cfg) {
        if (cfg instanceof IntegerConfig && ((IntegerConfig)cfg).isNumeric()) {
            return ((IntegerConfig)cfg).getValue();
        }
        if (cfg instanceof BooleanConfig && ((BooleanConfig)cfg).isBoolean()) {
            return ((BooleanConfig)cfg).getState() ? 1 : 0;
        }
        if (cfg instanceof DecimalConfig && ((DecimalConfig)cfg).isDecimal()) {
            return (int)(((DecimalConfig)cfg).getFloat() * 10000.0f);
        }
        if (cfg instanceof StringConfig && ((StringConfig)cfg).isString()) {
            return ((StringConfig)cfg).getString().hashCode();
        }
        return -1;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void dispatch(ClientLoginEvent evt) {
        ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.CONFIGSYNCSTART.ordinal(), (PacketTarget)new PacketTarget.ServerTarget(), new int[0]);
        for (String s : this.data.keySet()) {
            ReikaPacketHelper.sendStringIntPacket("DragonAPIData", APIPacketHandler.PacketIDs.CONFIGSYNC.ordinal(), new PacketTarget.ServerTarget(), s, this.data.get(s));
        }
        ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.CONFIGSYNCEND.ordinal(), (PacketTarget)new PacketTarget.ServerTarget(), new int[0]);
    }

    public void clear(EntityPlayer ep) {
        this.mismatch.remove(ep);
        this.checkedValues.remove(ep);
    }

    public void register(EntityPlayer ep, String s, int val) {
        Integer get;
        HashSet<String> set;
        HashMap<String, Mismatch> map = this.mismatch.get(ep);
        if (map == null) {
            map = new HashMap();
            this.mismatch.put(ep, map);
        }
        if ((set = this.checkedValues.get(ep)) == null) {
            set = new HashSet<String>(this.data.keySet());
            this.checkedValues.put(ep, set);
        }
        if ((get = this.data.get(s)) == null) {
            map.put(s, new ConfigStructureMismatch(s));
        } else if (get != val) {
            map.put(s, new Mismatch(s, get, val));
        }
        DragonAPICore.debug("Player " + ep.func_70005_c_() + " logging in. Performing config check. " + this.mismatch + " / " + this.data);
    }

    public void match(EntityPlayerMP ep) {
        ArrayList<Mismatch> c = new ArrayList<Mismatch>(this.mismatch.get((EntityPlayer)ep).values());
        if (!c.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            sb.append("Player " + ep.func_70005_c_() + " kicked: ");
            for (Mismatch m : c) {
                sb.append(m.getMessage());
                sb.append("; ");
                sb2.append(m.getLogMessage((EntityPlayer)ep));
                sb2.append("; ");
            }
            ReikaPlayerAPI.kickPlayer(ep, sb.toString());
            DragonAPICore.log(sb2.toString());
        }
    }

    private static class ConfigStructureMismatch
    extends Mismatch {
        protected ConfigStructureMismatch(String s) {
            super(s, 0, 0);
        }

        @Override
        protected String getMessage() {
            return "Different mod configuration structure: " + this.displayName + " missing on one side, likely indicating mod version mismatch";
        }
    }

    private static class Mismatch {
        protected final String displayName;
        protected final int serverValue;
        protected final int clientValue;

        protected Mismatch(String tag, int s, int c) {
            this.serverValue = s;
            this.clientValue = c;
            this.displayName = Mismatch.getDisplayName(tag);
        }

        private static String getDisplayName(String tag) {
            String[] parts = tag.split("::");
            return parts[0] + " - \"" + parts[1] + "\"";
        }

        protected String getMessage() {
            return "Critical config mismatch. Config Entry: " + this.displayName + ", Server Value=" + this.serverValue + ", Client Value=" + this.clientValue;
        }

        protected final String getLogMessage(EntityPlayer ep) {
            return "Client " + ep.func_70005_c_() + " attempted to join with a " + this.getMessage() + ". Login cannot continue.";
        }
    }
}

