/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;

public class ModularLogger {
    public static final ModularLogger instance = new ModularLogger();
    private final HashMap<String, LoggerElement> loggers = new HashMap();

    private ModularLogger() {
    }

    public void addLogger(DragonAPIMod mod, String label) {
        if (this.loggers.containsKey(label = label.toLowerCase(Locale.ENGLISH))) {
            throw new RegistrationException(mod, "Modular logger name '" + label + "' is already taken!");
        }
        this.loggers.put(label, new LoggerElement(mod, label));
    }

    public void log(String logger, String msg) {
        LoggerElement e = this.loggers.get(logger.toLowerCase(Locale.ENGLISH));
        if (e == null) {
            DragonAPICore.logError("Tried to use an unregistered logger '" + logger + "'!");
        } else if (e.enabled) {
            e.mod.getModLogger().log(msg);
        }
    }

    public boolean isEnabled(String logger) {
        LoggerElement e = this.loggers.get(logger.toLowerCase(Locale.ENGLISH));
        return e != null && e.enabled;
    }

    public void setState(String logger, boolean enable) {
        String id = logger.toLowerCase(Locale.ENGLISH);
        LoggerElement e = ModularLogger.instance.loggers.get(id);
        if (e != null) {
            e.enabled = enable;
        }
    }

    public static class ModularLoggerCommand
    extends DragonCommandBase {
        public void func_71515_b(ICommandSender ics, String[] args) {
            if (args.length != 2) {
                ModularLoggerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "You must specify a logger ID and a status!");
                return;
            }
            String id = args[0].toLowerCase(Locale.ENGLISH);
            LoggerElement e = (LoggerElement)instance.loggers.get(id);
            if (e == null) {
                ModularLoggerCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Unrecognized logger ID '" + args[0] + "'!");
                return;
            }
            e.enabled = args[1].equalsIgnoreCase("yes") || args[1].equalsIgnoreCase("enable") || args[1].equalsIgnoreCase("1") || Boolean.parseBoolean(args[1]);
            String status = e.enabled ? "enabled" : "disabled";
            ModularLoggerCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Logger '" + args[0] + "' " + status + ".");
            ReikaPacketHelper.sendStringIntPacket("DragonAPIData", APIPacketHandler.PacketIDs.MODULARLOGGER.ordinal(), new PacketTarget.AllPlayersTarget(), id, e.enabled ? 1 : 0);
        }

        @Override
        public String getCommandString() {
            return "modularlog";
        }

        @Override
        protected boolean isAdminOnly() {
            return true;
        }
    }

    private static final class LoggerElement {
        private final DragonAPIMod mod;
        private final String label;
        private boolean enabled;

        public LoggerElement(DragonAPIMod mod, String s) {
            this.mod = mod;
            this.label = s;
        }
    }
}

