/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkManager
implements ForgeChunkManager.LoadingCallback {
    public static final ChunkManager instance = new ChunkManager();
    private final HashMap<WorldLocation, ForgeChunkManager.Ticket> tickets = new HashMap();

    private ChunkManager() {
    }

    public void register() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)DragonAPIInit.instance, (ForgeChunkManager.LoadingCallback)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload evt) {
        Iterator<WorldLocation> it = this.tickets.keySet().iterator();
        while (it.hasNext()) {
            WorldLocation loc = it.next();
            if (loc.dimensionID != evt.world.field_73011_w.field_76574_g) continue;
            it.remove();
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int z;
            int y;
            NBTTagCompound nbt = ticket.getModData();
            int x = nbt.func_74762_e("tileX");
            TileEntity te = world.func_147438_o(x, y = nbt.func_74762_e("tileY"), z = nbt.func_74762_e("tileZ"));
            if (te instanceof ChunkLoadingTile) {
                ChunkLoadingTile tile = (ChunkLoadingTile)te;
                WorldLocation loc = new WorldLocation(te);
                this.forceTicketChunks(ticket, tile.getChunksToLoad());
                this.cacheTicket(loc, ticket);
                continue;
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    private void cacheTicket(WorldLocation loc, ForgeChunkManager.Ticket ticket) {
        this.tickets.put(loc, ticket);
    }

    public void unloadChunks(TileEntity te) {
        this.unloadChunks(new WorldLocation(te));
    }

    public void unloadChunks(World world, int x, int y, int z) {
        this.unloadChunks(new WorldLocation(world, x, y, z));
    }

    public void unloadChunks(WorldLocation loc) {
        ForgeChunkManager.Ticket ticket = this.tickets.remove(loc);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
    }

    public ForgeChunkManager.Ticket loadChunks(WorldLocation loc, Collection<ChunkCoordIntPair> chunks) {
        ForgeChunkManager.Ticket ticket = this.tickets.get(loc);
        if (ticket == null) {
            ticket = this.getNewTicket(loc);
            this.cacheTicket(loc, ticket);
        }
        this.forceTicketChunks(ticket, chunks);
        return ticket;
    }

    public void loadChunks(ChunkLoadingTile te) {
        WorldLocation loc = new WorldLocation((TileEntity)te);
        this.loadChunks(loc, te.getChunksToLoad());
    }

    private ForgeChunkManager.Ticket getNewTicket(WorldLocation loc) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)DragonAPIInit.instance, (World)loc.getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        NBTTagCompound nbt = ticket.getModData();
        nbt.func_74768_a("tileX", loc.xCoord);
        nbt.func_74768_a("tileY", loc.yCoord);
        nbt.func_74768_a("tileZ", loc.zCoord);
        return ticket;
    }

    private void forceTicketChunks(ForgeChunkManager.Ticket ticket, Collection<ChunkCoordIntPair> chunks) {
        ImmutableSet ticketChunks = ticket.getChunkList();
        for (ChunkCoordIntPair coord : ticketChunks) {
            if (chunks.contains(coord)) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord);
        }
        for (ChunkCoordIntPair coord : chunks) {
            if (ticketChunks.contains((Object)coord)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coord);
        }
    }

    public static Collection<ChunkCoordIntPair> getChunkSquare(int x, int z, int r) {
        int x2 = x >> 4;
        int z2 = z >> 4;
        ArrayList<ChunkCoordIntPair> chunkList = new ArrayList<ChunkCoordIntPair>();
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                chunkList.add(new ChunkCoordIntPair(x2 + i, z2 + k));
            }
        }
        return chunkList;
    }

    public String toString() {
        return this.tickets.toString();
    }
}

