/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI;

import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Auxiliary.PacketTypes;
import Reika.DragonAPI.Auxiliary.Trackers.CommandableUpdateChecker;
import Reika.DragonAPI.Auxiliary.Trackers.ConfigMatcher;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Auxiliary.Trackers.ModFileVersionChecker;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Command.BiomeMapCommand;
import Reika.DragonAPI.Command.EntityListCommand;
import Reika.DragonAPI.Command.IDDumpCommand;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Effects.NumberParticleFX;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLoginEvent;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLogoutEvent;
import Reika.DragonAPI.Instantiable.Event.Client.PlayerInteractEventClient;
import Reika.DragonAPI.Instantiable.Event.RawKeyPressEvent;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class APIPacketHandler
implements PacketHandler {
    private final Random rand = new Random();
    protected PacketIDs pack;

    @Override
    public void handleData(ReikaPacketHelper.PacketObj packet, World world, EntityPlayer ep) {
        DataInputStream inputStream = packet.getDataIn();
        int control = Integer.MIN_VALUE;
        int[] data = new int[]{};
        long longdata = 0L;
        float floatdata = 0.0f;
        int x = 0;
        int y = 0;
        int z = 0;
        boolean readinglong = false;
        NBTTagCompound NBT = null;
        String stringdata = null;
        try {
            PacketTypes packetType = packet.getType();
            switch (packetType) {
                case SOUND: {
                    return;
                }
                case FULLSOUND: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    break;
                }
                case STRING: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    break;
                }
                case DATA: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    int len = this.pack.getNumberDataInts();
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (int i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case UPDATE: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    break;
                }
                case FLOAT: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    floatdata = inputStream.readFloat();
                    break;
                }
                case SYNC: {
                    String name = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityData(world, x, y, z, name, inputStream);
                    return;
                }
                case TANK: {
                    String tank = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    int level = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityTankData(world, x, y, z, tank, level);
                    return;
                }
                case RAW: {
                    int i;
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    int len = this.pack.getNumberDataInts();
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case NBT: {
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    NBT = ((ReikaPacketHelper.DataPacket)packet).asNBT();
                    break;
                }
                case STRINGINT: {
                    int i;
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = PacketIDs.getEnum(control);
                    data = new int[this.pack.getNumberDataInts()];
                    for (i = 0; i < data.length; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
            }
            if (packetType.hasCoordinates()) {
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            switch (this.pack) {
                case BLOCKUPDATE: {
                    world.func_147471_g(x, y, z);
                    world.func_147479_m(x, y, z);
                    break;
                }
                case PARTICLE: {
                    for (int i = 0; i < data[1]; ++i) {
                        if (data[0] < 0 || data[0] >= ReikaParticleHelper.particleList.length) continue;
                        ReikaParticleHelper p = ReikaParticleHelper.particleList[data[0]];
                        world.func_72869_a(p.name, (double)x + this.rand.nextDouble(), (double)y + this.rand.nextDouble(), (double)z + this.rand.nextDouble(), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case BIOMECHANGE: {
                    ReikaWorldHelper.setBiomeForXZ(world, x, z, BiomeGenBase.field_76773_a[data[0]]);
                    world.func_147458_c(x, 0, z, x, world.field_73011_w.getActualHeight(), z);
                    break;
                }
                case KEYUPDATE: {
                    boolean used;
                    if (data.length < 2) {
                        DragonAPICore.logError("Caught key packet missing data (len=" + data.length + ")! Packet=" + packet);
                        break;
                    }
                    int ordinal = data[0];
                    boolean bl = used = data[1] > 0;
                    if (ordinal < 0 || ordinal > KeyWatcher.Key.keyList.length) {
                        DragonAPICore.logError("Caught key packet for key #" + ordinal + " (use=" + used + "), yet no such key exists. Packet=" + packet);
                        break;
                    }
                    KeyWatcher.Key key = KeyWatcher.Key.keyList[ordinal];
                    KeyWatcher.instance.setKey(ep, key, used);
                    MinecraftForge.EVENT_BUS.post((Event)new RawKeyPressEvent(key, ep));
                    break;
                }
                case TILESYNC: {
                    TileEntity te = world.func_147438_o(x, y, z);
                    if (!(te instanceof TileEntityBase) || world.field_72995_K) break;
                    TileEntityBase tile = (TileEntityBase)te;
                    tile.syncAllData(data[0] > 0);
                    break;
                }
                case VTILESYNC: {
                    int tx = NBT.func_74762_e("x");
                    int ty = NBT.func_74762_e("y");
                    int tz = NBT.func_74762_e("z");
                    TileEntity tile = world.func_147438_o(tx, ty, tz);
                    tile.func_145839_a(NBT);
                    break;
                }
                case TILEDELETE: {
                    world.func_147468_f(x, y, z);
                    break;
                }
                case PLAYERDATSYNC: 
                case PLAYERDATSYNC_CLIENT: {
                    for (Object o : NBT.func_150296_c()) {
                        String name = (String)o;
                        NBTBase tag = NBT.func_74781_a(name);
                        ep.getEntityData().func_74782_a(name, tag);
                    }
                    break;
                }
                case RERENDER: {
                    ReikaRenderHelper.rerenderAllChunks();
                    break;
                }
                case COLOREDPARTICLE: {
                    ReikaParticleHelper.spawnColoredParticlesWithOutset(world, x, y, z, data[0], data[1], data[2], data[3], (double)data[4] / 16.0);
                    break;
                }
                case NUMBERPARTICLE: {
                    break;
                }
                case IDDUMP: 
                case ENTITYDUMP: {
                    break;
                }
                case EXPLODE: {
                    break;
                }
                case OLDMODS: {
                    break;
                }
                case LOGIN: {
                    break;
                }
                case SERVERSOUND: {
                    if (!world.field_72995_K) break;
                    double dx = inputStream.readDouble();
                    double dy = inputStream.readDouble();
                    double dz = inputStream.readDouble();
                    String name = packet.readString();
                    float vol = inputStream.readFloat();
                    float pitch = inputStream.readFloat();
                    boolean flag = inputStream.readBoolean();
                    ReikaSoundHelper.playNormalClientSound(world, dx, dy, dz, name, vol, pitch, flag);
                    break;
                }
                case BREAKPARTICLES: {
                    break;
                }
                case PLAYERKICK: {
                    ((EntityPlayerMP)ep).field_71135_a.func_147360_c(stringdata);
                    break;
                }
                case CONFIGSYNCSTART: {
                    ConfigMatcher.instance.clear(ep);
                    break;
                }
                case CONFIGSYNC: {
                    ConfigMatcher.instance.register(ep, stringdata, data[0]);
                    break;
                }
                case CONFIGSYNCEND: {
                    ConfigMatcher.instance.match((EntityPlayerMP)ep);
                    break;
                }
                case ITEMDROPPER: {
                    break;
                }
                case ITEMDROPPERREQUEST: {
                    Entity e = world.func_73045_a(data[0]);
                    if (!(e instanceof EntityItem) || !e.getEntityData().func_74764_b("dropper")) break;
                    String s = e.getEntityData().func_74779_i("dropper");
                    ReikaPacketHelper.sendStringIntPacket("DragonAPIData", PacketIDs.ITEMDROPPER.ordinal(), (EntityPlayerMP)ep, s, data[0]);
                    break;
                }
                case PLAYERINTERACT: {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEventClient(ep, PlayerInteractEvent.Action.values()[data[4]], data[0], data[1], data[2], data[3], world));
                    break;
                }
                case GUIRELOAD: {
                    break;
                }
                case BIOMEPNGSTART: {
                    BiomeMapCommand.startCollecting(data[0], stringdata, data[1], data[2], data[3], data[4], data[5], data[6], data[7] > 0);
                    break;
                }
                case BIOMEPNGDAT: {
                    int hash = data[0];
                    for (int i = 0; i < 2048; ++i) {
                        int a = 1 + i * 3;
                        BiomeMapCommand.addBiomePoint(hash, data[a], data[a + 1], data[a + 2]);
                    }
                    break;
                }
                case BIOMEPNGEND: {
                    BiomeMapCommand.finishCollectingAndMakeImage(data[0]);
                    break;
                }
                case FILEMATCH: {
                    ModFileVersionChecker.instance.checkFiles((EntityPlayerMP)ep, stringdata);
                    break;
                }
                case ENTITYSYNC: {
                    int id = NBT.func_74762_e("dispatchID");
                    Entity e = world.func_73045_a(id);
                    if (e != null) {
                        e.func_70020_e(NBT);
                        break;
                    }
                    DragonAPICore.logError("Entity does not exist clientside to be synced!");
                    break;
                }
                case LOGOUT: {
                    break;
                }
                case MODULARLOGGER: {
                    ModularLogger.instance.setState(stringdata, data[0] > 0);
                }
            }
            if (world.field_72995_K) {
                this.clientHandle(world, x, y, z, this.pack, data, stringdata, ep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientHandle(World world, int x, int y, int z, PacketIDs pack, int[] data, String sg, EntityPlayer player) {
        switch (pack) {
            case NUMBERPARTICLE: {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new NumberParticleFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, data[0]));
                break;
            }
            case IDDUMP: {
                IDDumpCommand.dumpClientside(data[0]);
                break;
            }
            case ENTITYDUMP: {
                EntityListCommand.dumpClientside();
                break;
            }
            case EXPLODE: {
                ReikaSoundHelper.playSoundAtBlock(world, x, y, z, "random.explode");
                ReikaParticleHelper.EXPLODE.spawnAroundBlock(world, x, y, z, 1);
                break;
            }
            case OLDMODS: {
                CommandableUpdateChecker.instance.onClientReceiveOldModID(sg);
                break;
            }
            case LOGIN: {
                MinecraftForge.EVENT_BUS.post((Event)new ClientLoginEvent(player, data[0] > 0));
                break;
            }
            case LOGOUT: {
                MinecraftForge.EVENT_BUS.post((Event)new ClientLogoutEvent(player));
                break;
            }
            case BREAKPARTICLES: {
                Block b = Block.func_149729_e((int)data[0]);
                ReikaRenderHelper.spawnDropParticles(world, x, y, z, b, data[1]);
                break;
            }
            case ITEMDROPPER: {
                Entity e = world.func_73045_a(data[0]);
                if (!(e instanceof EntityItem)) break;
                e.getEntityData().func_74778_a("dropper", sg);
                break;
            }
            case GUIRELOAD: {
                if (Minecraft.func_71410_x().field_71462_r == null) break;
                Minecraft.func_71410_x().field_71462_r.func_73866_w_();
                break;
            }
        }
    }

    public static enum PacketIDs {
        BIOMECHANGE,
        BLOCKUPDATE,
        PARTICLE,
        KEYUPDATE,
        TILESYNC,
        VTILESYNC,
        TILEDELETE,
        PLAYERDATSYNC,
        PLAYERDATSYNC_CLIENT,
        RERENDER,
        COLOREDPARTICLE,
        NUMBERPARTICLE,
        IDDUMP,
        ENTITYDUMP,
        EXPLODE,
        OLDMODS,
        LOGIN,
        LOGOUT,
        SERVERSOUND,
        BREAKPARTICLES,
        PLAYERKICK,
        CONFIGSYNC,
        CONFIGSYNCSTART,
        CONFIGSYNCEND,
        ITEMDROPPER,
        ITEMDROPPERREQUEST,
        PLAYERINTERACT,
        GUIRELOAD,
        BIOMEPNGSTART,
        BIOMEPNGDAT,
        BIOMEPNGEND,
        FILEMATCH,
        ENTITYSYNC,
        MODULARLOGGER;


        public static PacketIDs getEnum(int index) {
            return PacketIDs.values()[index];
        }

        public boolean isLongPacket() {
            return false;
        }

        public boolean hasLocation() {
            return this != KEYUPDATE && this != PLAYERKICK && this != CONFIGSYNC && this != CONFIGSYNCEND && this != FILEMATCH && this != MODULARLOGGER;
        }

        public int getNumberDataInts() {
            switch (this) {
                case PARTICLE: {
                    return 2;
                }
                case NUMBERPARTICLE: {
                    return 1;
                }
                case COLOREDPARTICLE: {
                    return 5;
                }
                case BIOMECHANGE: {
                    return 1;
                }
                case KEYUPDATE: {
                    return 2;
                }
                case TILESYNC: {
                    return 1;
                }
                case IDDUMP: {
                    return 1;
                }
                case BREAKPARTICLES: {
                    return 2;
                }
                case CONFIGSYNC: {
                    return 1;
                }
                case ITEMDROPPER: 
                case ITEMDROPPERREQUEST: {
                    return 1;
                }
                case PLAYERINTERACT: {
                    return 5;
                }
                case BIOMEPNGSTART: {
                    return 8;
                }
                case BIOMEPNGDAT: {
                    return 6145;
                }
                case BIOMEPNGEND: {
                    return 1;
                }
                case LOGIN: {
                    return 1;
                }
                case MODULARLOGGER: {
                    return 1;
                }
            }
            return 0;
        }
    }
}

