/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.resources;

import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemCell
extends ItemIC2 {
    private final Map<Integer, InternalName> names = new HashMap<Integer, InternalName>();
    private final Map<Block, ItemStack> cells = new IdentityHashMap<Block, ItemStack>();

    public ItemCell(InternalName internalName) {
        super(internalName);
        this.func_77627_a(true);
        Ic2Items.cell = this.addCell(0, InternalName.itemCellEmpty, new Block[0]);
        Ic2Items.waterCell = this.addCell(1, InternalName.itemCellWater, new Block[]{Blocks.field_150355_j, Blocks.field_150358_i});
        Ic2Items.lavaCell = this.addCell(2, InternalName.itemCellLava, new Block[]{Blocks.field_150353_l, Blocks.field_150356_k});
        Ic2Items.uuMatterCell = this.addRegisterCell(3, InternalName.itemCellUuMatter, InternalName.fluidUuMatter);
        Ic2Items.CFCell = this.addRegisterCell(4, InternalName.itemCellCF, InternalName.fluidConstructionFoam);
        Ic2Items.airCell = this.addCell(5, InternalName.itemCellAir, new Block[0]);
        Ic2Items.biomassCell = this.addRegisterCell(6, InternalName.itemCellBiomass, InternalName.fluidBiomass);
        Ic2Items.biogasCell = this.addRegisterCell(7, InternalName.itemCellBiogas, InternalName.fluidBiogas);
        Ic2Items.electrolyzedWaterCell = this.addCell(8, InternalName.itemCellWaterElectro, new Block[0]);
        Ic2Items.coolantCell = this.addRegisterCell(9, InternalName.itemCellCoolant, InternalName.fluidCoolant);
        Ic2Items.hotcoolantCell = this.addRegisterCell(10, InternalName.itemCellHotCoolant, InternalName.fluidHotCoolant);
        Ic2Items.pahoehoelavaCell = this.addRegisterCell(11, InternalName.itemCellPahoehoelava, InternalName.fluidPahoehoeLava);
        Ic2Items.distilledwaterCell = this.addRegisterCell(12, InternalName.itemCellDistilledWater, InternalName.fluidDistilledWater);
        Ic2Items.superheatedsteamCell = this.addRegisterCell(13, InternalName.itemCellSuperheatedSteam, InternalName.fluidSuperheatedSteam);
        Ic2Items.steamCell = this.addRegisterCell(14, InternalName.itemCellSteam, InternalName.fluidSteam);
        FluidContainerRegistry.registerFluidContainer((Fluid)FluidRegistry.WATER, (ItemStack)Ic2Items.waterCell.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
        FluidContainerRegistry.registerFluidContainer((Fluid)FluidRegistry.LAVA, (ItemStack)Ic2Items.lavaCell.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
    }

    @Override
    public String getTextureFolder() {
        return "cell";
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        InternalName ret = this.names.get(stack.func_77960_j());
        if (ret == null) {
            return null;
        }
        return "ic2." + ret.name();
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        ItemStack stack;
        for (int meta = 0; meta < Short.MAX_VALUE && this.func_77667_c(stack = new ItemStack((Item)this, 1, meta)) != null; ++meta) {
            itemList.add(stack);
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        MovingObjectPosition position = this.func_77621_a(world, player, true);
        if (position == null) {
            return false;
        }
        if (position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            x = position.field_72311_b;
            y = position.field_72312_c;
            z = position.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return false;
            }
            if (!player.func_82247_a(x, y, z, position.field_72310_e, stack)) {
                return false;
            }
            if (stack.func_77960_j() == 0) {
                ItemStack filledCell;
                if (world.func_72805_g(x, y, z) == 0 && (filledCell = this.cells.get(world.func_147439_a(x, y, z))) != null && StackUtil.storeInventoryItem(filledCell.func_77946_l(), player, false)) {
                    world.func_147468_f(x, y, z);
                    --stack.field_77994_a;
                    return true;
                }
            } else {
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[position.field_72310_e];
                if (fs != null && LiquidUtil.placeFluid(fs, world, x, y, z) || player.func_82247_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, position.field_72310_e, stack) && LiquidUtil.placeFluid(fs, world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private ItemStack addCell(int meta, InternalName name, Block ... blocks) {
        this.names.put(meta, name);
        ItemStack ret = new ItemStack((Item)this, 1, meta);
        for (Block block : blocks) {
            this.cells.put(block, ret);
        }
        return ret;
    }

    private ItemStack addRegisterCell(int meta, InternalName name, InternalName blockName) {
        ItemStack ret = this.addCell(meta, name, BlocksItems.getFluidBlock(blockName));
        FluidContainerRegistry.registerFluidContainer((Fluid)BlocksItems.getFluid(blockName), (ItemStack)ret.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
        return ret;
    }
}

