/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.tinkersconstruct;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonTinkersTiles
implements IWailaDataProvider {
    private static final String CONFIG_DRYER_TIME = "wawla.tinkers.showDryerTime";
    private static final String CONFIG_DRYER_ITEM = "wawla.tinkers.showDryerItem";
    private static final String CONFIG_SLAB_FURNACE = "wawla.tinkers.showFurnace";
    private static final String CONFIG_BURN_TIME = "wawla.tinkers.showBurnTime";
    private static final String CONFIG_HIDE_LANDMINES = "wawla.tinkers.hideLandmine";
    private static boolean isEnabled = false;
    private static Class classHarvestTool = null;
    private static Class classDualHarvestTool = null;
    private static Class classDryingRackLogic = null;
    private static Class classFurnaceLogic = null;
    private static Class classBlockLandmine = null;
    private static Class classDryingRack = null;
    private static Class classFurnaceSlab = null;
    private static Method getHarvestType = null;
    private static Method getSecondHarvestType = null;

    public AddonTinkersTiles() {
        if (Loader.isModLoaded((String)"TConstruct")) {
            isEnabled = true;
            try {
                classHarvestTool = Class.forName("tconstruct.library.tools.HarvestTool");
                classDualHarvestTool = Class.forName("tconstruct.library.tools.DualHarvestTool");
                classDryingRackLogic = Class.forName("tconstruct.blocks.logic.DryingRackLogic");
                classFurnaceLogic = Class.forName("tconstruct.tools.logic.FurnaceLogic");
                classBlockLandmine = Class.forName("tconstruct.mechworks.blocks.BlockLandmine");
                classDryingRack = Class.forName("tconstruct.armor.blocks.DryingRack");
                classFurnaceSlab = Class.forName("tconstruct.tools.blocks.FurnaceSlab");
                getHarvestType = classHarvestTool.getDeclaredMethod("getHarvestType", new Class[0]);
                getSecondHarvestType = classDualHarvestTool.getDeclaredMethod("getSecondHarvestType", new Class[0]);
                getHarvestType.setAccessible(true);
                getSecondHarvestType.setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        ItemStack cover;
        if (cfg.getConfig(CONFIG_HIDE_LANDMINES) && data.getTileEntity() != null && Utilities.compareByClass(classBlockLandmine, data.getBlock().getClass()) && data.getNBTData() != null && (cover = Utilities.getInventoryStacks(data.getNBTData(), 4)[3]) != null) {
            return cover;
        }
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        if (data.getBlock() != null && data.getTileEntity() != null) {
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), classDryingRackLogic)) {
                double percent;
                ItemStack item;
                if (cfg.getConfig(CONFIG_DRYER_ITEM) && (item = Utilities.getInventoryStacks(data.getNBTData(), 1)[0]) != null) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.item") + ": " + item.func_82833_r());
                }
                if (cfg.getConfig(CONFIG_DRYER_TIME) && (percent = Utilities.round(Utilities.getProgression(data.getNBTData().func_74762_e("Time"), data.getNBTData().func_74762_e("MaxTime")), 2)) > 0.0 && !(percent > 100.0)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.tinkers.dryness") + ": " + percent + "%");
                }
            }
            if (Utilities.compareTileEntityByClass(data.getTileEntity(), classFurnaceLogic)) {
                int burnTime;
                if (cfg.getConfig(CONFIG_BURN_TIME) && (burnTime = data.getNBTData().func_74762_e("Fuel") / 20) > 0 && cfg.getConfig("wawla.furnace.burntime")) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.burnTime") + ": " + burnTime + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
                }
                if (cfg.getConfig(CONFIG_SLAB_FURNACE) && data.getPlayer().func_70093_af()) {
                    ItemStack[] furnaceStacks = Utilities.getInventoryStacks(data.getNBTData(), 3);
                    if (furnaceStacks[0] != null && cfg.getConfig("wawla.furnace.input")) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.input") + ": " + furnaceStacks[0].func_82833_r() + " X " + furnaceStacks[0].field_77994_a);
                    }
                    if (furnaceStacks[1] != null && cfg.getConfig("wawla.furnace.fuel")) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.fuel") + ": " + furnaceStacks[1].func_82833_r() + " X " + furnaceStacks[1].field_77994_a);
                    }
                    if (furnaceStacks[2] != null && cfg.getConfig("wawla.furnace.output")) {
                        tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.output") + ": " + furnaceStacks[2].func_82833_r() + " X " + furnaceStacks[2].field_77994_a);
                    }
                }
            }
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonTinkersTiles dataProvider = new AddonTinkersTiles();
        register.addConfig("Tinkers' Construct", CONFIG_HIDE_LANDMINES);
        register.addConfig("Tinkers' Construct", CONFIG_DRYER_TIME);
        register.addConfig("Tinkers' Construct", CONFIG_DRYER_ITEM);
        register.addConfig("Tinkers' Construct", CONFIG_SLAB_FURNACE);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classDryingRack);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classFurnaceSlab);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classDryingRack);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classBlockLandmine);
        register.registerStackProvider((IWailaDataProvider)dataProvider, classBlockLandmine);
    }

    public static boolean canHarvest(ItemStack item, String required) {
        if (isEnabled) {
            ArrayList<String> tooltypes = new ArrayList<String>();
            if (classDualHarvestTool.isInstance(item.func_77973_b())) {
                try {
                    tooltypes.add((String)getSecondHarvestType.invoke((Object)item.func_77973_b(), new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (classHarvestTool.isInstance(item.func_77973_b())) {
                try {
                    tooltypes.add((String)getHarvestType.invoke((Object)item.func_77973_b(), new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return tooltypes.contains(required);
        }
        return false;
    }
}

