/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.items;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.content.BOPCFluids;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.ItemFluidContainer;

public class ItemBOPBucket
extends ItemFluidContainer {
    private static HashMap<String, IIcon> bucketIcons = new HashMap();

    public ItemBOPBucket() {
        super(0, 1000);
        this.field_77777_bU = 1;
        this.func_77637_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, false);
        if (movingobjectposition != null) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)movingobjectposition.field_72310_e);
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile != null && tile instanceof IFluidHandler) {
                IFluidHandler tank = (IFluidHandler)tile;
                if (tank.fill(direction, this.getFluid(itemStack), false) == this.getCapacity(itemStack)) {
                    tank.fill(direction, this.getFluid(itemStack), true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        return new ItemStack(Items.field_151133_ar);
                    }
                }
                return itemStack;
            }
            if (movingobjectposition.field_72310_e == 0) {
                --y;
            }
            if (movingobjectposition.field_72310_e == 1) {
                ++y;
            }
            if (movingobjectposition.field_72310_e == 2) {
                --z;
            }
            if (movingobjectposition.field_72310_e == 3) {
                ++z;
            }
            if (movingobjectposition.field_72310_e == 4) {
                --x;
            }
            if (movingobjectposition.field_72310_e == 5) {
                ++x;
            }
            if (!player.func_82247_a(x, y, z, movingobjectposition.field_72310_e, itemStack)) {
                return itemStack;
            }
            if (this.tryPlaceContainedLiquid(itemStack, world, x, y, z) && !player.field_71075_bZ.field_75098_d) {
                return new ItemStack(Items.field_151133_ar);
            }
        }
        return itemStack;
    }

    public boolean tryPlaceContainedLiquid(ItemStack itemStack, World world, int x, int y, int z) {
        FluidStack fluid = this.getFluid(itemStack);
        if (fluid == null || fluid.amount == 0) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean isSolid = material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && isSolid) {
            return false;
        }
        if (!(world.field_72995_K || isSolid || material.func_76224_d())) {
            world.func_147480_a(x, y, z, true);
        }
        int meta = fluid.getFluid() == BOPCFluids.honey ? 7 : 0;
        world.func_147465_d(x, y, z, fluid.getFluid().getBlock(), meta, 3);
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        ItemStack fluid = new ItemStack(item);
        this.fill(fluid, new FluidStack(BOPCFluids.poison, 1000), true);
        list.add(fluid);
        fluid = new ItemStack(item);
        this.fill(fluid, new FluidStack(BOPCFluids.blood, 1000), true);
        list.add(fluid);
        fluid = new ItemStack(item);
        this.fill(fluid, new FluidStack(BOPCFluids.honey, 1000), true);
        list.add(fluid);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        bucketIcons.put("poison", iconRegister.func_94245_a("biomesoplenty:bucket_poison"));
        bucketIcons.put("honey", iconRegister.func_94245_a("biomesoplenty:bucket_honey"));
        bucketIcons.put("hell_blood", iconRegister.func_94245_a("biomesoplenty:bucket_blood"));
    }

    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        IIcon icon;
        FluidStack fluid = this.getFluid(itemStack);
        if (fluid != null && fluid.amount != 0 && (icon = bucketIcons.get(fluid.getFluid().getName())) != null) {
            return icon;
        }
        return Items.field_151133_ar.func_77617_a(0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public String func_77653_i(ItemStack itemStack) {
        FluidStack fluid = this.getFluid(itemStack);
        if (fluid != null && fluid.amount != 0) {
            return StatCollector.func_74838_a((String)(fluid.getFluid().getUnlocalizedName().replace("fluid.", "item.") + "Bucket" + ".name"));
        }
        return Items.field_151133_ar.func_77658_a() + ".name";
    }
}

